float4x4 mWVP;
float g_e ;

struct VS_OUTPUT
{
  float4 Pos    : POSITION;
	float2 Tex		: TEXCOORD0;
};

texture SrcMap;
sampler SrcSamp = sampler_state
{
    Texture = <SrcMap>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = NONE;

    AddressU = Clamp;
    AddressV = Clamp;
};


VS_OUTPUT VS_pass1(
      float4 Pos    : POSITION,
      float4 Tex    : TEXCOORD0
){
    VS_OUTPUT Out = (VS_OUTPUT)0;
    
    Out.Pos = Pos ;
    Out.Tex = Tex ;

    return Out;
}

float4 PS_pass1(VS_OUTPUT In) : COLOR
{
	float4 Out ;
	
	Out = tex2D( SrcSamp, In.Tex ) ;
	Out += tex2D( SrcSamp, float2(In.Tex.x , In.Tex.y - 8/1024.0f ) ) ;
	Out += tex2D( SrcSamp, float2(In.Tex.x- 8/1024.0f , In.Tex.y  ) ) ;
		
	return Out/3 ;
}

technique TShader
{
    pass P0
    {
        VertexShader = compile vs_1_1 VS_pass1();

        PixelShader  = compile ps_1_4 PS_pass1();
        
				Sampler[0] = (SrcSamp);
    }
}
