
//============================================================================//
// O[o

float   g_fWeight[8];
float   g_fPower;
texture g_tImage;

#define GS_SIZE 256

//============================================================================//
// Tv`

sampler SrcSamp = sampler_state
{
	Texture = <g_tImage>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = LINEAR;
	AddressU  = Clamp;
	AddressV  = Clamp;
};

//============================================================================//
// }XLO

struct MaskGlowVS_Out
{
	float4 Pos : POSITION;
	float2 Tex : TEXCOORD;
};

MaskGlowVS_Out MaskGlowVS(
	float4 Pos : POSITION,
	float2 Tex : TEXCOORD
){
	MaskGlowVS_Out Out;
	Out.Pos = Pos;
	Out.Tex = Tex + float2(0.5/GS_SIZE,0.5/GS_SIZE);
	return Out;
}

float4 MaskGlowPS( float2 Tex : TEXCOORD ) : COLOR
{
	float4 T = tex2D( SrcSamp, Tex );
	T.rgb *= T.a;
	return T;
}

//============================================================================//
// [Vu[

float4 MotionBlurPS( float2 Tex : TEXCOORD ) : COLOR
{
	float4 T = tex2D( SrcSamp, Tex );
	T.a = 0.25f;
	return T;
}

//============================================================================//
// KEXtB^

struct GaussFilterVS_Out
{
	float4 Pos : POSITION;
	float2 T0  : TEXCOORD0;
	float2 T1  : TEXCOORD1;
	float2 T2  : TEXCOORD2;
	float2 T3  : TEXCOORD3;
	float2 T4  : TEXCOORD4;
	float2 T5  : TEXCOORD5;
	float2 T6  : TEXCOORD6;
	float2 T7  : TEXCOORD7;
};

GaussFilterVS_Out GaussFilterVS(
	float4 Pos : POSITION,
	float2 Tex : TEXCOORD,
	uniform float2 ofs
){
	GaussFilterVS_Out Out;

	Out.Pos = Pos;

	Out.T0 = Tex -  1 * ofs;
	Out.T1 = Tex -  3 * ofs;
	Out.T2 = Tex -  5 * ofs;
	Out.T3 = Tex -  7 * ofs;
	Out.T4 = Tex -  9 * ofs;
	Out.T5 = Tex - 11 * ofs;
	Out.T6 = Tex - 13 * ofs;
	Out.T7 = Tex - 15 * ofs;

	return Out;
}

float4 GaussFilterPS( GaussFilterVS_Out In, uniform float2 ofs ) : COLOR
{
	float4 Color;

	Color  = g_fWeight[0] * ( tex2D(SrcSamp,In.T0) + tex2D(SrcSamp,In.T7 + ofs) );
	Color += g_fWeight[1] * ( tex2D(SrcSamp,In.T1) + tex2D(SrcSamp,In.T6 + ofs) );
	Color += g_fWeight[2] * ( tex2D(SrcSamp,In.T2) + tex2D(SrcSamp,In.T5 + ofs) );
	Color += g_fWeight[3] * ( tex2D(SrcSamp,In.T3) + tex2D(SrcSamp,In.T4 + ofs) );
	Color += g_fWeight[4] * ( tex2D(SrcSamp,In.T4) + tex2D(SrcSamp,In.T3 + ofs) );
	Color += g_fWeight[5] * ( tex2D(SrcSamp,In.T5) + tex2D(SrcSamp,In.T2 + ofs) );
	Color += g_fWeight[6] * ( tex2D(SrcSamp,In.T6) + tex2D(SrcSamp,In.T1 + ofs) );
	Color += g_fWeight[7] * ( tex2D(SrcSamp,In.T7) + tex2D(SrcSamp,In.T0 + ofs) );

	return Color;
}

float4 RenderGlowPS( float2 Tex : TEXCOORD ) : COLOR
{
	return tex2D( SrcSamp, Tex ) * g_fPower;
}

//============================================================================//
// KEXtB^eNjbN

technique GaussFilter
{
	// O[̃}XLO
	pass P0
	{
		VertexShader = compile vs_1_1 MaskGlowVS();
		PixelShader  = compile ps_2_0 MaskGlowPS();
		ZEnable = False;
	}

	// KEXtB^
	pass P1
	{
		VertexShader = compile vs_1_1 GaussFilterVS( float2( 1/256.0,0) );
		PixelShader  = compile ps_2_0 GaussFilterPS( float2(16/256.0,0) );
		ZEnable = False;
	}

	// KEXtB^
	pass P2
	{
		VertexShader = compile vs_1_1 GaussFilterVS( float2(0, 1/256.0) );
		PixelShader  = compile ps_2_0 GaussFilterPS( float2(0,16/256.0) );
		ZEnable = False;
	}

	// O[̃[Vu[
	pass P3
	{
		VertexShader = compile vs_1_1 MaskGlowVS();
		PixelShader  = compile ps_2_0 MotionBlurPS();
		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = One;
		DestBlend = SrcAlpha;
	}

	// ŏI`
	pass P4
	{
		VertexShader = compile vs_1_1 MaskGlowVS();
		PixelShader  = compile ps_2_0 RenderGlowPS();

		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = One;
		DestBlend = One;
	}
}

//============================================================================//

