
//============================================================================//
// O[o

texture g_tImage;
float4  g_cMaterial;

//============================================================================//
// Tv`

sampler ImageSamp = sampler_state
{
	Texture = <g_tImage>;
};

//============================================================================//




//============================================================================//
// v[

float4 RenderPlanePS() : COLOR
{
	return g_cMaterial;
}

technique RenderPlane
{
	pass P0
	{
		VertexShader = NULL;
		PixelShader  = compile ps_2_0 RenderPlanePS();
		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

//============================================================================//
// C[W

float4 RenderImagePS( float4 Col : COLOR, float2 Tex : TEXCOORD ) : COLOR
{
	return Col * tex2D(ImageSamp,Tex);
}

technique RenderImage
{
	pass P0
	{
		VertexShader = NULL;
		PixelShader  = compile ps_2_0 RenderImagePS();
		ZEnable = False;
		AlphaBlendEnable = True;
		SrcBlend  = SrcAlpha;
		DestBlend = InvSrcAlpha;
	}
}

//============================================================================//

