function fx_barrelScroll_init()
{
	document.fx_barrelScroll_w	= 64
	document.fx_barrelScroll_h	= 48
	document.fx_barrelScroll_imgDataIso	= buildBmp24Header( document.fx_barrelScroll_w, document.fx_barrelScroll_h )
	document.fx_barrelScroll_barrelLut = []


	scrollLut = []
	scrollLut[ 0 ] = "                                 "
	scrollLut[ 1 ] = "     aa   aa aaaa aaaaaa    aaa  aaaa aaaa  aa          "
	scrollLut[ 2 ] = "     aa   aa aa     aa     aa aa aa   aa    aa      "
	scrollLut[ 3 ] = "     aa   aa aaaa   aa     aa aa aaaa aaaa  aa           "
	scrollLut[ 4 ] = "     aa   aa aa     aa     aa aa aa   aa            "
	scrollLut[ 5 ] = "     aaaa aa aa     aa      aaa  aa   aa    aa         "
	scrollLut[ 6 ] = "                                    "
	scrollLut[ 7 ] = "                                       "

	scrollLutMaxLen = scrollLut[ 0 ].length
	for( j=1; j<8; j++ )
		scrollLutMaxLen = Math.max( scrollLutMaxLen, scrollLut[ j ].length )


	for( j=0; j<8; j++ )
	{
		document.fx_barrelScroll_barrelLut[ j ] = []
		currentScrollLutLen = scrollLut[ j ].length
		for( i=0; i<currentScrollLutLen; i++ )
			document.fx_barrelScroll_barrelLut[ j ][ i ] = scrollLut[ j ].charAt( i )!=" "
		for( ; i<scrollLutMaxLen; i++ )
			document.fx_barrelScroll_barrelLut[ j ][ i ] = 0
	}




	document.fx_barrelScroll_shadeLut = []
	for( j=0; j<h; j++ )
	{
		x = Math.round( Math.round( 7*(1-Math.asin( Math.abs( (j-h/2)*2/h ) )/Math.PI*2) ) *255/7 )
		document.fx_barrelScroll_shadeLut[ j ]			= byteToIsoArray[ x ]+byteToIsoArray[ x ]+byteToIsoArray[ x ]
	}


	document.fx_barrelScroll_angularOffsetLut	= []
	xLut		= []
	for( j=0; j<64; j++ )
	{
		document.fx_barrelScroll_angularOffsetLut[ j ] = []
		Y = j*8/64
		for( i=0; i<h; i++ )
		{
			document.fx_barrelScroll_angularOffsetLut[ j ][ i ]	= Math.round( (.5+Math.asin( (i-h/2)*2/h )/Math.PI)*48+Y )&7
		}
	}

	progressBarIndex++
}

function fx_barrelScroll_update( time, extraArguments )
{
	var
		i,j,
		w					= document.fx_barrelScroll_w,
		h					= document.fx_barrelScroll_h,
		imgDataIso			= document.fx_barrelScroll_imgDataIso,
		barrelLut			= document.fx_barrelScroll_barrelLut,
		shadeLut			= document.fx_barrelScroll_shadeLut,
		angularOffsetLut	= document.fx_barrelScroll_angularOffsetLut,
		y = time/256




	anOffsetLut	= []
	xLut		= []
	j = barrelLut[ 0 ].length
	for( i=w; i--; )
	{
		anOffsetLut[ i ]	= Math.round( y*4+ 128*Math.sin( y/4-1.5*Math.cos( 1-i/w-y/16 ) ) )&63
		xLut[ i ]			= (Math.round( y*4+w-i +6*(1+Math.cos(y/3+i/w)) )>>1)%j
	}



	for( j=0; j<h; j++ )
	{
		shade = shadeLut[ j ]
		for( i=w; i--; )
			imgDataIso += barrelLut[ angularOffsetLut[ anOffsetLut[ i ] ][ j ] ][ xLut[ i ] ]?shade:"\0\0\0"
	}

	customImageHandle.src	= imgDataIso
}