// Distortion. 10 is nice boom, 60 is glass brick
uniform float distort;
// Scale. 0.0-1.0
uniform float scale;
uniform sampler2D Noise1;

varying vec2 vTexCoord;

void main(void)
{
  vec2 coord = vTexCoord;
  vec2 center = vec2(.5);

  vec2 v = coord-center;

  float len = v.x*v.x + v.y*v.y;

  v *= 1.0 - scale + sin(v*distort)*scale;

  coord = center+v;

  vec4 col = texture2D(Noise1, coord);
  
  gl_FragColor = col;

}

