/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class PlasmaEffect
extends Effect {
    Random rand;
    int[] plasmaBuffer;
    int[] palette = new int[256];
    int timeElapsed;

    public PlasmaEffect(DemoCanvas demo) {
        super(demo);
    }

    public void init(int[] timePoints) {
        super.init(timePoints);
        this.rand = new Random();
        this.plasmaBuffer = new int[this.width * this.height];
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < this.palette.length; ++i) {
            g = (int)(128.0 + 128.0 * Math.sin(3.1415 * (double)i / 32.0));
            b = (int)(128.0 + 128.0 * Math.sin(3.1415 * (double)i / 128.0));
            this.palette[i] = r << 16 | g << 8 | b;
        }
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.plasmaBuffer[y * this.width + x] = Math.min((int)(128.0 + 128.0 * Math.sin((double)x / 16.0) + 128.0 + 128.0 * Math.sin((double)y / 16.0) + 128.0 + 128.0 * Math.sin(Math.sqrt(x * x + y * y) / 8.0) + 128.0 + 128.0 * Math.sin(Math.sqrt(((double)x - (double)this.width / 2.0) * ((double)x - (double)this.width / 2.0) + ((double)y - (double)this.height / 2.0) * ((double)y - (double)this.height / 2.0)) / 8.0)) / 3, 255);
            }
        }
    }

    public void doLogic(int msPassed) {
        this.timeElapsed += msPassed;
        int i = 0;
        while (true) {
            if (i >= DemoCanvas.frameBuffer.length) break;
            DemoCanvas.frameBuffer[i] = this.palette[this.plasmaBuffer[i] + this.timeElapsed & 0xFF];
            ++i;
        }
    }

    public void draw(Graphics g) {
        g.drawRGB(DemoCanvas.frameBuffer, 0, this.width, 0, 0, this.width, this.height, false);
    }
}

