/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TunnelEffect
extends Effect {
    Random rand;
    char[] uvTab;
    Image texImage;
    int[] tex;
    int ms;
    Image overlay;

    public TunnelEffect(DemoCanvas demo) {
        super(demo);
    }

    public void init(int[] timePoints) {
        super.init(timePoints);
        this.rand = new Random();
        this.ms = 0;
        this.uvTab = new char[this.width * 2 * this.height * 2];
        for (int j = 0; j < this.height * 2; ++j) {
            for (int i = 0; i < this.width * 2; ++i) {
                int x = i - this.width;
                int y = j - this.height;
                int sum = x * x + y * y;
                float r = (float)Math.sqrt(sum);
                if ((double)r == 0.0) {
                    r = 0.01f;
                }
                int iRadius = (int)(3500.0f / r);
                float angle = (float)Float11.acos((double)x / (double)r);
                if ((double)y > 0.0) {
                    angle = (float)Math.PI * 2 - angle;
                }
                int iAngle = (int)((double)angle * 256.0 / (Math.PI * 2));
                this.uvTab[j * this.width * 2 + i] = (char)((iRadius & 0xFF) << 8 | iAngle & 0xFF);
            }
        }
        try {
            this.texImage = Image.createImage((String)"/tiles.png");
            this.tex = new int[this.texImage.getWidth() * this.texImage.getHeight()];
            this.texImage.getRGB(this.tex, 0, this.texImage.getWidth(), 0, 0, this.texImage.getWidth(), this.texImage.getHeight());
        }
        catch (Exception e) {
            System.out.println("could not set up tex");
            e.printStackTrace();
        }
        try {
            this.overlay = Image.createImage((String)"/perkele.png");
        }
        catch (Exception e) {
            System.out.println("could not set up overlay");
            e.printStackTrace();
        }
    }

    public void doLogic(int msPassed) {
        this.ms += msPassed;
        int bOffs = 0;
        double t = (double)this.ms / 10.0;
        double a = Math.sin(t / 100.0);
        double b = Math.cos(t / 70.0);
        int xPos = (int)(a * 50.0 + 50.0);
        int yPos = (int)(b * 50.0 + 50.0);
        int tOffs = yPos * this.width * 2 + xPos;
        int tScrollU = (int)t & 0xFF;
        int tScrollV = (int)t * 2 & 0xFF;
        int tScroll = tScrollU << 8 | tScrollV;
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                DemoCanvas.frameBuffer[bOffs++] = this.tex[this.uvTab[tOffs++] + tScroll & 0xFFFF];
            }
            tOffs += this.width;
        }
    }

    public void draw(Graphics g) {
        this.demo.commitFrameBuffer = true;
    }
}

