/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class OrangeEffect
extends Effect {
    Random rand;
    int[] fireBuffer;
    int[] palette = new int[256];
    int[] wantedParticlePos;
    int[] actualParticlePos;
    Image text;
    int[] textInts;
    int heightMask;
    int widthMask;
    int coalesceDuration;
    boolean coalesce;
    int startCoalesce = 3000;

    public OrangeEffect(DemoCanvas demo) {
        super(demo);
    }

    public void init(int[] timePoints, int startCoalesce, int stopCoalesce, Image text) {
        int i;
        super.init(timePoints);
        this.rand = new Random();
        this.height = 128;
        this.heightMask = this.height - 1;
        this.startCoalesce = startCoalesce;
        this.coalesceDuration = stopCoalesce - startCoalesce;
        this.fireBuffer = new int[this.width * this.height];
        boolean r = false;
        boolean g = false;
        boolean b = false;
        for (int i2 = 0; i2 < this.palette.length; ++i2) {
            this.palette[i2] = i2 << 16 | i2 << 8 | 0;
        }
        this.textInts = new int[this.width * this.height];
        text.getRGB(this.textInts, 0, this.width, 0, 0, this.width, this.height);
        int numParticles = 0;
        for (int i3 = 0; i3 < this.textInts.length; ++i3) {
            if ((this.textInts[i3] & 0xFFFFFF) == 0) continue;
            ++numParticles;
        }
        System.out.println(numParticles + " particles");
        this.wantedParticlePos = new int[numParticles];
        this.actualParticlePos = new int[numParticles];
        int off = 0;
        for (i = 0; i < this.textInts.length; ++i) {
            if ((this.textInts[i] & 0xFFFFFF) == 0) continue;
            this.wantedParticlePos[off++] = i;
        }
        for (i = 0; i < this.wantedParticlePos.length; ++i) {
            this.actualParticlePos[i] = Math.abs(this.rand.nextInt()) % this.textInts.length;
        }
    }

    public void doLogic(int msPassed) {
        int i;
        this.coalesce = this.timePoints[this.currentAppearance + 1] - this.timeToLive > this.startCoalesce;
        for (i = 0; i < this.actualParticlePos.length; ++i) {
            if (this.coalesce) {
                int gotX = this.actualParticlePos[i] % this.width;
                int gotY = this.actualParticlePos[i] / this.width;
                int wantX = this.wantedParticlePos[i] % this.width;
                int wantY = this.wantedParticlePos[i] / this.width;
                int mod = 0;
                mod = (wantX - gotX) * (this.timePoints[this.currentAppearance + 1] - this.timeToLive - this.startCoalesce) / this.coalesceDuration;
                int newX = gotX + mod;
                mod = (wantY - gotY) * (this.timePoints[this.currentAppearance + 1] - this.timeToLive - this.startCoalesce) / this.coalesceDuration;
                int newY = gotY + mod;
                this.actualParticlePos[i] = newY * this.width + newX;
            }
            this.fireBuffer[this.actualParticlePos[i]] = Math.abs(this.rand.nextInt()) & 0xFF;
        }
        for (int y = 0; y < this.height / 2; ++y) {
            int oneRowDown = (y + 1 & this.heightMask) * this.width;
            int twoRowsDown = (y + 2 & this.heightMask) * this.width;
            int curRow = y * this.width;
            for (int x = 0; x < this.width; ++x) {
                this.fireBuffer[curRow + x] = (this.fireBuffer[oneRowDown + (x - 1) % this.width] + this.fireBuffer[oneRowDown + (x + 1) % this.width] + this.fireBuffer[twoRowsDown + x % this.width] + this.fireBuffer[oneRowDown + x % this.width]) * 48 / 257;
                this.fireBuffer[this.fireBuffer.length - curRow - this.width + x] = (this.fireBuffer[this.fireBuffer.length - this.width - oneRowDown + (x - 1) % this.width] + this.fireBuffer[this.fireBuffer.length - this.width - oneRowDown + (x + 1) % this.width] + this.fireBuffer[this.fireBuffer.length - this.width - twoRowsDown + x % this.width] + this.fireBuffer[this.fireBuffer.length - this.width - oneRowDown + x % this.width]) * 48 / 257;
            }
        }
        for (i = 0; i < this.fireBuffer.length; ++i) {
            DemoCanvas.frameBuffer[i] = this.palette[this.fireBuffer[i]];
        }
    }

    public void draw(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.demo.getWidth(), this.demo.getHeight());
        g.drawRGB(DemoCanvas.frameBuffer, 0, this.width, 0, this.demo.getHeight() - this.height >> 1, this.width, this.height, false);
    }
}

