/*
 * Decompiled with CFR 0.152.
 */
package com.mascotcapsule.micro3d.v3;

import com.mascotcapsule.micro3d.v3.Effect3D;
import com.mascotcapsule.micro3d.v3.Figure;
import com.mascotcapsule.micro3d.v3.FigureLayout;
import com.mascotcapsule.micro3d.v3.Texture;
import com.mascotcapsule.micro3d.v3.Util3D;
import javax.microedition.lcdui.Graphics;

public class Graphics3D {
    public static final int COMMAND_LIST_VERSION_1_0 = -33554431;
    public static final int COMMAND_END = Integer.MIN_VALUE;
    public static final int COMMAND_NOP = -2130706432;
    public static final int COMMAND_FLUSH = -2113929216;
    public static final int COMMAND_ATTRIBUTE = -2097152000;
    public static final int COMMAND_CLIP = -2080374784;
    public static final int COMMAND_CENTER = -2063597568;
    public static final int COMMAND_TEXTURE_INDEX = -2046820352;
    public static final int COMMAND_AFFINE_INDEX = -2030043136;
    public static final int COMMAND_PARALLEL_SCALE = -1879048192;
    public static final int COMMAND_PARALLEL_SIZE = -1862270976;
    public static final int COMMAND_PERSPECTIVE_FOV = -1845493760;
    public static final int COMMAND_PERSPECTIVE_WH = -1828716544;
    public static final int COMMAND_AMBIENT_LIGHT = -1610612736;
    public static final int COMMAND_DIRECTION_LIGHT = -1593835520;
    public static final int COMMAND_THRESHOLD = -1358954496;
    public static final int PRIMITVE_POINTS = 0x1000000;
    public static final int PRIMITVE_LINES = 0x2000000;
    public static final int PRIMITVE_TRIANGLES = 0x3000000;
    public static final int PRIMITVE_QUADS = 0x4000000;
    public static final int PRIMITVE_POINT_SPRITES = 0x5000000;
    public static final int POINT_SPRITE_LOCAL_SIZE = 0;
    public static final int POINT_SPRITE_PIXEL_SIZE = 1;
    public static final int POINT_SPRITE_PERSPECTIVE = 0;
    public static final int POINT_SPRITE_NO_PERS = 2;
    public static final int ENV_ATTR_LIGHTING = 1;
    public static final int ENV_ATTR_SPHERE_MAP = 2;
    public static final int ENV_ATTR_TOON_SHADING = 4;
    public static final int ENV_ATTR_SEMI_TRANSPARENT = 8;
    public static final int PATTR_LIGHTING = 1;
    public static final int PATTR_SPHERE_MAP = 2;
    public static final int PATTR_COLORKEY = 16;
    public static final int PATTR_BLEND_NORMAL = 0;
    public static final int PATTR_BLEND_HALF = 32;
    public static final int PATTR_BLEND_ADD = 64;
    public static final int PATTR_BLEND_SUB = 96;
    public static final int PDATA_NORMAL_NONE = 0;
    public static final int PDATA_NORMAL_PER_FACE = 512;
    public static final int PDATA_NORMAL_PER_VERTEX = 768;
    public static final int PDATA_COLOR_NONE = 0;
    public static final int PDATA_COLOR_PER_COMMAND = 1024;
    public static final int PDATA_COLOR_PER_FACE = 2048;
    public static final int PDATA_TEXURE_COORD_NONE = 0;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_CMD = 4096;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_FACE = 8192;
    public static final int PDATA_POINT_SPRITE_PARAMS_PER_VERTEX = 12288;
    public static final int PDATA_TEXURE_COORD = 12288;
    private int p;
    private int mWidth;
    private int mHeight;
    private int mpBuffer;
    private static boolean mIsBound = false;
    private Graphics mGraphics;
    private transient boolean m_3dDirty = false;
    private transient boolean m_gDirty = false;
    private static int ID = 0;
    private int m_ID = ID++;

    private native void finalize();

    private native int renderPrimT(Texture var1, int var2, int var3, FigureLayout var4, Effect3D var5, int var6, int[] var7, int[] var8, int[] var9, int[] var10);

    private native int drawCmdT(Texture[] var1, int var2, int var3, FigureLayout var4, Effect3D var5, int[] var6);

    private native int makeI();

    private native int renderFig(Figure var1, int var2, int var3, FigureLayout var4, Effect3D var5);

    private native void bindVRam(int var1, int var2, int var3, int var4);

    private native void releaseVRam();

    private native int drawFig(Figure var1, int var2, int var3, FigureLayout var4, Effect3D var5);

    private native void render();

    private native void capture();

    private final void checkTargetIsValid() throws IllegalStateException {
        if (this.mGraphics == null) {
            throw new IllegalStateException("No target is bound");
        }
    }

    private static native void initializeClass0();

    public Graphics3D() {
        this.p = this.makeI();
        if (this.p == 0) {
            throw Util3D.rue;
        }
    }

    public final synchronized void bind(Graphics graphics) throws IllegalStateException, NullPointerException {
        if (mIsBound) {
            throw new IllegalStateException("Target already bound");
        }
        this.mGraphics = graphics;
        int cx = graphics.getClipX() + graphics.getTranslateX();
        int cy = graphics.getClipY() + graphics.getTranslateY();
        int cw = graphics.getClipWidth();
        int ch = graphics.getClipHeight();
        this.bindVRam(cx, cy, cw, ch);
        mIsBound = true;
        this.m_gDirty = true;
    }

    public final synchronized void release(Graphics graphics) throws IllegalArgumentException, NullPointerException {
        if (graphics != this.mGraphics) {
            throw new IllegalArgumentException("Unknown target");
        }
        if (graphics == this.mGraphics && mIsBound) {
            if (this.m_3dDirty) {
                this.render();
                this.m_3dDirty = false;
            }
            this.releaseVRam();
            this.mGraphics = null;
            mIsBound = false;
        }
    }

    public final void renderPrimitives(Texture texture, int x, int y, FigureLayout layout, Effect3D effect, int command, int numPrimitives, int[] vertexCoords, int[] normals, int[] textureCoords, int[] colors) {
        if (layout == null || effect == null) {
            throw Util3D.npe;
        }
        if (vertexCoords == null || normals == null || textureCoords == null || colors == null) {
            throw Util3D.npe;
        }
        if (command < 0) {
            throw Util3D.iae;
        }
        if (numPrimitives <= 0 || numPrimitives >= 256) {
            throw Util3D.iae;
        }
        if (texture != null && texture.p == 0) {
            throw Util3D.rueD;
        }
        int ret = this.renderPrimT(texture, x, y, layout, effect, command | numPrimitives << 16, vertexCoords, normals, textureCoords, colors);
        if (ret == -1) {
            throw Util3D.rue;
        }
        if (ret != 0) {
            throw Util3D.iae;
        }
    }

    public final void drawCommandList(Texture[] textures, int x, int y, FigureLayout layout, Effect3D effect, int[] commandList) {
        int ret;
        if (layout == null || effect == null) {
            throw Util3D.npe;
        }
        if (textures != null) {
            int i;
            for (i = 0; i < textures.length; ++i) {
                if (textures[i] != null) continue;
                throw Util3D.npe;
            }
            for (i = 0; i < textures.length; ++i) {
                if (textures[i].p != 0) continue;
                throw Util3D.rueD;
            }
        }
        if (commandList == null) {
            throw Util3D.npe;
        }
        if (this.m_gDirty) {
            this.capture();
            this.m_gDirty = false;
        }
        if ((ret = this.drawCmdT(textures, x, y, layout, effect, commandList)) == -1) {
            throw Util3D.rue;
        }
        if (ret != 0) {
            throw Util3D.iae;
        }
        this.m_3dDirty = true;
    }

    public final void drawCommandList(Texture texture, int x, int y, FigureLayout layout, Effect3D effect, int[] commandList) {
        Texture[] ta = null;
        if (texture != null) {
            ta = new Texture[]{texture};
        }
        this.drawCommandList(ta, x, y, layout, effect, commandList);
    }

    public final void renderFigure(Figure figure, int x, int y, FigureLayout layout, Effect3D effect) throws IllegalStateException {
        this.checkTargetIsValid();
        if (figure == null || layout == null || effect == null) {
            throw Util3D.npe;
        }
        if (this.p == 0) {
            return;
        }
        int ret = this.renderFig(figure, x, y, layout, effect);
        if (ret == -1) {
            throw Util3D.rue;
        }
        if (ret != 0) {
            throw Util3D.iae;
        }
    }

    public final void drawFigure(Figure figure, int x, int y, FigureLayout layout, Effect3D effect) throws IllegalStateException {
        int ret;
        this.checkTargetIsValid();
        if (figure == null || layout == null || effect == null) {
            throw Util3D.npe;
        }
        if (this.p == 0) {
            return;
        }
        if (this.m_gDirty) {
            this.capture();
            this.m_gDirty = false;
        }
        if ((ret = this.drawFig(figure, x, y, layout, effect)) == -1) {
            throw Util3D.rue;
        }
        if (ret != 0) {
            throw Util3D.iae;
        }
        this.m_3dDirty = true;
    }

    private final native int flu();

    public final void flush() throws IllegalStateException {
        int ret;
        this.checkTargetIsValid();
        if (this.m_gDirty) {
            this.capture();
            this.m_gDirty = false;
        }
        if ((ret = this.flu()) != 0) {
            throw Util3D.rue;
        }
        this.m_3dDirty = true;
    }

    public final void dispose() {
        if (this.p == 0) {
            return;
        }
        this.finalize();
        this.p = 0;
    }

    static {
        Graphics3D.initializeClass0();
    }
}

