struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha;
float V_Var1; // Intens

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color;
  float  value;
  color     = tex2D(Sampler, In.Tex0);
  color.a   = V_Alpha * color.a;
  value     = (color.r+color.g+color.b)/3.0;
  if (value < V_Var1)
    color = 0;
  return color;
}

technique Emboss
{
  pass PassEmboss
  {
    PixelShader = compile ps_2_0 PS();
  }
}
