/*  DS
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#ifndef MDEMO_H
#define MDEMO_H

#include "common.h"
#include "mscene.h"
#include <SDL/SDL_thread.h>

namespace DS
{
	typedef struct { int width, height, bpp, samplerate;
			bool fullscreen, sound, loop;
			std::string title, info; } Settings;
			
	class MDemo {
	public:
		~MDemo();
		static MDemo* Instance();
		void Run(int argc, char **argv);
		void AddScene(Scene* pScene);
		void Init(int width, int height, int bpp, bool fullscreen,	
			const char* pWindowTitle, const char* pInfoText, int samplerate,
			bool sound, const char* pDataDirectory, bool loop, int loopstart);
	
		bool m_displayThreadActive;
		bool m_loadThreadActive;
		bool m_startLoading;
		int m_loopstart;
		LoadStates m_loadstates;
		Settings m_settings;
	protected:
		MDemo();
	private:
		static MDemo* m_pInstance;
		Scene* m_pLoaderScene;
			
		MScene* m_pMScene;
		MMusic* m_pMMusic;
		MTexture* m_pMTexture;
		MVideo* m_pMVideo;
		MModel* m_pMModel;
			
		SDL_Thread* m_pLoadThread;
		SDL_Thread* m_pDisplayThread;
	};
}

#endif
