/*  DS
 *  Copyright (C) Anders Asplund and Joakim Kolsjö 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */

#include "mmodel.h"
#include "dirlist.h"
#include "mdemo.h"

using namespace std;

namespace DS
{	
	MModel::MModel(const char* pBaseDirectory)
	{
		m_BaseDirectory = pBaseDirectory;
		m_BaseDirectory += "/models";
	}
	

	MModel::~MModel()
	{
		if(m_models.size() > 0)
		{			
			std::map <std::string, Model*>::iterator iter = m_models.begin();
			while(iter != m_models.end())
			{
				delete iter->second;
				++iter;
			}
		}	
	}
	
	void MModel::Instance(const char* pBaseDirectory)
	{	
		if(!m_pInstance)
			m_pInstance = new MModel(pBaseDirectory);
	}
	
	MModel* MModel::GetPointer()
	{
		return m_pInstance;
	}
	
	int MModel::LoadSingle(const char* pIdentity)
	{
		string file = m_BaseDirectory + "/" + pIdentity + ".ms3d";

		Model* pModel = new Model;
		if(pModel->Load(file.c_str())) {
			cout << "[MModel::LoadSingle] Failed to load: " << file << endl;
			return 1;
		}
			
		m_models[pIdentity] = pModel;
		m_modelNames.push_back(pIdentity);

		return 0;
	}
	
	int MModel::LoadGLTextures()
	{
		for(int i = 0; i < (int)m_modelNames.size(); i++)
		{
			if(m_models[m_modelNames[i]]->LoadGLTextures())
				return 1;
		}
		return 0;
	}
	
	int MModel::Load(float &state, bool &active)
	{				
		vector<string> models = DS::DirectoryList::GetPointer()->GetFileList(m_BaseDirectory.c_str());
		
		// Check how many models we're going to load
		int total = 0, current = 1;
		for(int i = 0; i < (int)models.size(); i++)
			if(models[i].substr(models[i].size()-4, 4) == "ms3d")
				if(!m_models[models[i].substr(m_BaseDirectory.size()+1, models[i].size() - m_BaseDirectory.size()-6)])
					total++;

		// Load models			
		for(int i = 0; i < (int)models.size(); i++)
		{
			if(models[i].substr(models[i].size()-4, 4) == "ms3d")
			{
				string identity = models[i].substr(m_BaseDirectory.size()+1, models[i].size() - m_BaseDirectory.size()-6);

				if(!active)
					return 0;
				
				if(!m_models[identity])
				{
					state = ((float)current++/total);
					if(LoadSingle(identity.c_str()))
						return 1;
				}
			}
		}
		return 0;
	}

	Model* MModel::GetModel(const char* pIdentity)
	{
		if(!m_models[pIdentity] && LoadSingle(pIdentity))
		{
			cout << "[MModel::GetModel] \"" << pIdentity << "\" does not exist." << endl;
			return 0;
		}
		return m_models[pIdentity];
	}
	
	std::vector<std::string> MModel::GetList()
	{
		return m_modelNames;
	}
	
	std::vector<std::string> MModel::GetList(const char* pHead)
	{
		// Get list of model Identity's that start with the contents of pHead.
		vector<string> outlist;
		string head = pHead;
		int size = head.size();
		if(size > 0)
		{
			for(int i = 0; i < (int)m_modelNames.size(); i++)
			{
				if(m_modelNames[i].substr(0, size) == head)
					outlist.push_back(m_modelNames[i]);
			}
		}
		
		sort(outlist.begin(), outlist.end());
		return outlist;
	}
}
