/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "loader.h"
#include <vector>

using namespace std;

namespace Scene
{			
	Loader::~Loader()
	{

	}
	
	void Loader::EnterScene()
	{	
		glClearColor(0.0, 0.0, 0.0, 0);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(0, 640, 480, 0, 1, 100);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
	} 

	void Loader::ExitScene()
	{	
		
	} 
	
	int Loader::LoadScene()
	{	
#ifdef DEBUG
		m_identity = "Loader";
#endif
		m_pMTexture->GetTexture("loader");
		m_pMTexture->MakeGLTextures();
		return 0;
	} 
	
	int Loader::DrawFrame(long time, float move, LoadStates* pLoadStates)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
		
		// Calculate current loading state
		float state = 0;
		for(int i = 0; i < pLoadStates->nValues; i++) {
			state += pLoadStates->pValues[i];
		}
		state /= pLoadStates->nValues;
					
		// Make shure loading is never shorter than 1.5 second :)
#ifndef DEBUG
		EVENT(0, 1500)
			state *= ((float)time/1500);
#endif
		
		static float blackout = 1.0;
		// Progress indicator ----------------------------------------------
		glEnable(GL_BLEND);
		glPushMatrix();
		glTranslatef(0, 480-(state*480), -5);
			glBegin(GL_QUADS);
				glColor3f(blackout, 0, 0);
				glTexCoord2f(1.0f, 0.0f); 
				glVertex3f(640, 480, 0);
				glTexCoord2f(1.0f, 1.0f);
				glVertex3f(640-80, 480, 0);
				glTexCoord2f(0.0f, 1.0f);
				glVertex3f(640-80, 0, 0);
				glTexCoord2f(0.0f, 0.0f);
				glVertex3f(640, 0, 0);
			glEnd();
		glPopMatrix();
		
		// Background ------------------------------------------------------
		glEnable(GL_TEXTURE_2D);				
		glPushMatrix();
			glTranslatef(0, 0, -1);	
			BIND_TEX("loader");
			glBegin(GL_QUADS);
				glColor3f(blackout, blackout, blackout);
				glTexCoord2f(1.0f, 0.0f); 
				glVertex3f(640, 480, 0);
				glTexCoord2f(1.0f, 1.0f);
				glVertex3f(640, 0, 0);
				glTexCoord2f(0.0f, 1.0f);
				glVertex3f(0, 0, 0);
				glTexCoord2f(0.0f, 0.0f);
				glVertex3f(0, 480, 0);
			glEnd();
		glPopMatrix();	
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
			
		// Blackout --------------------------------------------------------
		if(state == 1)
		{	
#if 1
			if(blackout > 0)
				Change(blackout, move, -1);
			else
				blackout = 0;
			
			static long out = time;
			if((time - out) > 1000)
				return END_SCENE;
			else
				return CONTINUE;
#else
			return END_SCENE;
#endif
		}
		return CONTINUE;
	}
}
