/*  xa-004: Beatbox invitro 
 *  Copyright (C) Joakim Kolsjö and Anders Asplund 2005
 *	This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
 */ 

#include "scene2.h"
#include <vector>
#include "png.h"

using namespace std;

// Scene end time
#define END 27600

namespace Scene
{			
	Scene2::~Scene2()
	{
		delete m_pBFrame;
		delete m_pText;
	}
	
	void Scene2::EnterScene()
	{	
		glShadeModel(GL_SMOOTH);
		glEnable(GL_DEPTH_TEST);
		glDepthFunc(GL_LEQUAL);
		
		glClearDepth(1);
		glClearColor(0.0, 0.0, 0.0, 0);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE);
		
		GLfloat ratio = (GLfloat)4/3;
		glViewport(0, 0, m_pMVideo->GetWidth(), m_pMVideo->GetHeight());
		
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, ratio, 1, 100);
    
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();
	} 
	
	int Scene2::LoadScene()
	{	
#ifdef DEBUG
		m_identity = "Info";
#endif
		
		m_texts.push_back("THIS SUMMER");
		m_texts.push_back("8-10/JULY");
		m_texts.push_back("TUMBA/SWEDEN");
		m_texts.push_back("");
		m_texts.push_back("");
		m_texts.push_back("");
		m_texts.push_back("");
						
		m_pText = new Tools::PText();
		m_pBFrame = new Tools::PRect(200, 2.5, 0.35, 3);
		return 0;
	} 
	
	int Scene2::DrawFrame(long time, float move)
	{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glLoadIdentity();
				
		static float textswitch = 0;
		static float fadeout = 1;
		static float expand = 0;
		static float fadein = 0;
		
		if(fadein < 1)
			Change(fadein, move, 0.5);
		else
			fadein = 1;
		
		// Beatbox -------------------------------------------------------------
		EVENT(0, END);
		{	
			EVENT(END-1000, END)
			{
				if(fadeout > 0)
					Change(fadeout, move, -1);
				else
					fadeout = 0;
			}

			EVENT(END-10000, END)
			{
				Change(expand, move, 0.125);
			}
				glEnable(GL_BLEND);
			glPushMatrix();
			
				glEnable(GL_TEXTURE_2D);
	
				// Beatbox
				glTranslatef(-2, 0, -25);
				glScalef(0.35, 0.35, (1+expand)*sin(time*0.001));	
				glPushMatrix();
				m_pText->Draw(move, 1*fadeout,
					1*fadeout, 1*fadeout, 10, "BEATBOX", false);
				glPopMatrix();
				
				// Frame
				glTranslatef(5, 0, -2.5);
				glScalef(30, 30, 30);	
				m_pBFrame->Draw(move, 0.75*fadeout, 0.7 + expand*4);
				
				glDisable(GL_TEXTURE_2D);
			
			glPopMatrix();
			glDisable(GL_BLEND);
		}
		
		// Stars ---------------------------------------------------------------
		EVENT(7000, END)
		{
			static DS::Model* pModel = DS::MModel::GetPointer()->GetModel("8star");
			static float red[] = { 1, 0, 0, 1 };
			static float gre[] = { 0, 1, 0, 1 };
			static float blu[] = { 0, 0, 1, 1 };
			static float colorpos = 0;
			
			static float diffrot = 0;
			EVENT(13800, END)
			{
				Change(colorpos, move, 2.5);
				if(!diffrot)
					diffrot = time*0.08;
			}
					
			glPushMatrix();
				glTranslatef(4.5, -3.2, -10);
				glColor3f(red[(int)colorpos%4]*fadeout,
					gre[(int)colorpos%4]*fadeout,
					blu[(int)colorpos%4]*fadeout);
				glRotatef(time * 0.08, 0, 0, 1);
				EVENT(13800, END)
					glRotatef(time * 0.08 - diffrot, 1, 1, 0);
				glScalef(0.03, 0.03, 0.03);
				pModel->Draw();
			glPopMatrix();
			
			EVENT(8700, END)
			{
				glPushMatrix();
					glTranslatef(4.5, 3.2, -10);
					glColor3f(red[(int)(colorpos+1)%4]*fadeout,
						gre[(int)(colorpos+1)%4]*fadeout,
						blu[(int)(colorpos+1)%4]*fadeout);
					glRotatef(time * 0.08, 0, 0, 1);
					EVENT(13800, END)
						glRotatef(time * 0.08 - diffrot, 1, 1, 0);
					glScalef(0.03, 0.03, 0.03);
					pModel->Draw();
				glPopMatrix();
			}
			
			EVENT(10400, END)
			{
				glPushMatrix();
					glTranslatef(-4.5, 3.2, -10);
					glColor3f(red[(int)(colorpos+2)%4]*fadeout,
						gre[(int)(colorpos+2)%4]*fadeout,
						blu[(int)(colorpos+2)%4]*fadeout);
					glRotatef(time * 0.08, 0, 0, 1);
					EVENT(13800, END)
						glRotatef(time * 0.08 - diffrot, 1, 1, 0);
					glScalef(0.03, 0.03, 0.03);
					pModel->Draw();
				glPopMatrix();
			}
			
			EVENT(12100, END)
			{
				glPushMatrix();
					glTranslatef(-4.5, -3.2, -10);
					glColor3f(red[(int)(colorpos+3)%4]*fadeout,
						gre[(int)(colorpos+3)%4]*fadeout,
						blu[(int)(colorpos+3)%4]*fadeout);
					glRotatef(time * 0.08, 0, 0, 1);
					EVENT(13800, END)
						glRotatef(time*0.08 - diffrot, 1, 1, 0);
					glScalef(0.03, 0.03, 0.03);
					pModel->Draw();
				glPopMatrix();	
			}
		}

		// Top and bottom ------------------------------------------------------
		glEnable(GL_BLEND);
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		glOrtho(0, 640, 480, 0, 1, 100);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		
		glEnable(GL_TEXTURE_2D);				
		glPushMatrix();
			glColor3f(fadeout*fadein, fadeout*fadein, fadeout*fadein);
			glTranslatef(0, 0, -90);	
			BIND_TEX("scene2_info_bot");
			glBegin(GL_QUADS);
				glTexCoord2f(1.0f, 0.0f); 
				glVertex3f(640, 480, 0);
				glTexCoord2f(1.0f, 1.0f);
				glVertex3f(640, 480-120, 0);
				glTexCoord2f(0.0f, 1.0f);
				glVertex3f(0, 480-120, 0);
				glTexCoord2f(0.0f, 0.0f);
				glVertex3f(0, 480, 0);
			glEnd();
			BIND_TEX("scene2_info_top");
			glBegin(GL_QUADS);
				glTexCoord2f(1.0f, 0.0f); 
				glVertex3f(640, 120, 0);
				glTexCoord2f(1.0f, 1.0f);
				glVertex3f(640, 0, 0);
				glTexCoord2f(0.0f, 1.0f);
				glVertex3f(0, 0, 0);
				glTexCoord2f(0.0f, 0.0f);
				glVertex3f(0, 120, 0);
			glEnd();
		glPopMatrix();	
		glDisable(GL_TEXTURE_2D);
			glDisable(GL_BLEND);
			
		glMatrixMode(GL_PROJECTION);
		glLoadIdentity();
		gluPerspective(45, (float)4/3, 1, 100);
    	glMatrixMode(GL_MODELVIEW);
    	glLoadIdentity();
		
		if(time >= END)
			return END_SCENE;
		else
			return CONTINUE;
	}
}
