#include "laberinto.h"

using namespace std;


void laberinto :: generarlab(int semilla){      

            ConjuntosDisjuntos conj(fil*col);
            vector<int> vec(fil*col-1);
			vector<int> vaux(fil*col-1);
			int cont = 1;
            
                        //Fila de abajo  (solo a derechas)          
            for(int i = col*(fil-1); i<vec.size();i++){
				vec[i]= 2;
			}
			           //Columna de la derecha (solo hacia abajo)
            for(int i = col-1;i<vec.size();i=i+col){//protege ultima columna derecha
				vec[i]=1;
			}
			for(int i = 0; i<vaux.size();i++){ //inicializa cada posicion a su indice
				vaux[i] = i;
			}
                        
                        
            //0 Muros sin derribar
            //1 Derribar solo el muro de abajo
            //2 Derribar solo el muro de la derecha
            //3 Todos los muros derribados   
                     
			int celda1, fil1,col1,muro, clase = 0;
            int  elem1, elem2, pos_vec, estado_muro;   
            srand(semilla);
            while(clase != fil*col-1)            //solo hay una clase
            {
		celda1 = (int)(((double)rand()/(RAND_MAX+1.0))*(fil*col-cont));
            fil1 = vaux[celda1]/col;  //fila celda
            col1 = vaux[celda1]%col;  //col celda
            pos_vec = vaux[celda1];
			estado_muro = vec[pos_vec];
			elem1 = conj.Clase(pos_vec);
			if(estado_muro == 0)
                 {
				  muro = (int)(((double)rand()/(RAND_MAX+1.0))*2);//para acotar a las dos posibilidades del muro
				  if(muro == 0) //miramos si podemos  derribar el muro de la derecha
                  {  
				    elem2 = conj.Clase(pos_vec+1);
				    if(elem1 != elem2)
                    {
				      conj.Union (elem1, elem2);
				      vec[pos_vec] = 1;//solo queda el de abajo
				      lab[fil1][col1].derecha = false;
				      clase++;
				    }
				  }

				  else
                   {           //miramos si podemos  derribar el muro de la abajo
				    elem2 = conj.Clase(pos_vec+col);
				    if(elem1 != elem2) 
                      {
				      conj.Union (elem1, elem2);
				      vec[pos_vec] = 2;//solo queda el de la derecha
				      lab[fil1][col1].debajo = false;
				      clase++;
				      }
				  }
				}
			else if(estado_muro == 1 ) //solo queda abajo, lo derribaremos
               {
				  elem2 = conj.Clase(pos_vec+col);
				  if(elem1 != elem2)
                  {
				    conj.Union (elem1, elem2);
				    vec[pos_vec] = 3;//no queda ninguno
				    lab[fil1][col1].debajo = false;
				    clase++;
				  }
				  cont++;
				  vaux[celda1]=vaux[fil*col-cont];
				}
				else if (estado_muro == 2){//solo queda derecha, lo derribaremos
				  elem2 = conj.Clase(pos_vec+1);
				  if(elem1 != elem2){
				    conj.Union (elem1, elem2);
				    vec[pos_vec] = 3;//no queda ninguno
				    lab[fil1][col1].derecha = false;
				    clase++;
				  }
				  cont++;
				  vaux[celda1]=vaux[fil*col-cont];
				}
			}
};





// Esta es la funcin que puedes aprovechar para generar los laberintos
// en Postscript, reemplazando los identificadores en maysculas por
// la informacin correspondiente segn tu representacin de los laberintos.

void laberinto :: Postscript(ostream & fsal) {
  float escala;
  fsal << "%!PS-Adobe-2.0 EPSF-2.0\n";
  if (fil > 80  ||  col > 55)
    escala = 80.0/fil < 55.0/col ?
             80.0/fil : 55.0/col;
  else
    escala = 1.0;
  fsal << "%%BoundingBox: 0 0 " << ((int)(col*escala)+4)*10;
  fsal << " " << ((int)(fil*escala)+4)*10 << "\n";
  fsal << "newpath 0 " << ((int)(fil*escala)+4)*10;
  fsal << " moveto 0 0 lineto " << ((int)(col*escala)+4)*10;
  fsal << " 0 lineto " <<  ((int)(col*escala)+4)*10;
  fsal << " " << ((int)(fil*escala)+4)*10;
  fsal << " lineto closepath clip\n";
  fsal << escala << " " << escala << " scale\n";
  fsal << "/unidad {10 mul} def\n";

  fsal << "/vector [\n";
  for (int i=0 ; i < fil ; i++) {
    for (int j=0 ; j < col ; j++) {
      if (lab[i][j].debajo)
        fsal << "1 ";
      else
        fsal << "0 ";
      if (lab[i][j].derecha)
        fsal << "1 ";
      else
        fsal << "0 ";
    }
    fsal << "\n";
  }
  fsal << "] def\n";

  fsal << "newpath\n";
  fsal << "2 unidad " << fil+1 << " unidad moveto\n";
  fsal << "0 " << col*2 << " " << fil*col*2-1 << " {";
  fsal << "    /i exch def\n";
  fsal << "    0 2 " << col*2-1 <<   " {";
  fsal << "        /j exch def\n";
  fsal << "        vector i j add get 1 eq {\n";
  fsal << "            1 unidad 0 unidad rlineto\n";
  fsal << "        }{\n";
  fsal << "            1 unidad 0 unidad rmoveto\n";
  fsal << "        } ifelse\n";
  fsal << "        0 unidad vector i j add 1 add get unidad rlineto\n";
  fsal << "        0 unidad vector i j add 1 add get -1 mul unidad rmoveto\n";
  fsal << "    } for\n";
  fsal << "    j 2 add 2 div -1 mul unidad -1 unidad rmoveto\n";
  fsal << "} for\n";
  fsal << "stroke\n";

  fsal << "newpath\n";
  fsal << "2 setlinewidth\n";
  fsal << "2 unidad " << fil+1 << " unidad moveto\n";
  fsal << "0 unidad " << -fil+1 << " unidad rlineto\n";
  fsal << col << " unidad 0 unidad rlineto\n";
  fsal << "0 unidad 1 unidad rmoveto\n";
  fsal << "0 unidad " << fil-1 << " unidad rlineto\n";
  fsal << -col << " unidad 0 unidad rlineto\n";
  fsal << "stroke\n";
  fsal << "showpage\n";
}

