float4x4 transform;
float4x4 viewWorldTransform;
float4x4 projTransform;

struct output_t
{
  float4 pos : POSITION;
  float2 texCoord : TEXCOORD0;
  float4 color : TEXCOORD1;
};

float particleSize;

output_t main(float4 pos : POSITION, float2 texCoord : TEXCOORD0, float4 color : COLOR0)
{
  output_t vsOut;
	    
  float2 tPos;

  if (texCoord.x<0.5)
    tPos.x = -particleSize;
  else
	tPos.x = particleSize;

  if (texCoord.y<0.5)
    tPos.y = particleSize;
  else
    tPos.y = -particleSize;

  vsOut.pos = mul(transform, pos);
  vsOut.pos.xy +=tPos;
  vsOut.texCoord = texCoord;
  vsOut.color = color;
  return vsOut;
}
