float4x4 mWVP;
texture Texture0;
texture Texture1;
//ȉ[JWn
float3 LightDir;
float3 LightPos;
float3 EyePos;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float3 L		:	TEXCOORD1;
	float3 E		:	TEXCOORD2;//JxNg
	float3 N		:	COLOR0;
	float4 Col		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	float4 amb = {0.2f,0.2f,0.2f,1.0f};//ArGg
	float3 YVec  = {0.01f,1.0f,0.01f};//YxNg
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	//Out.Tex0 = Tex0;
	//Out.Tex1 = Tex1;
	//ڃxNgƂ߂
	float3 B = normalize(cross(Nor,YVec));
	float3 T = normalize(cross(B,Nor));//ڃxNg
	B = normalize(cross(Nor,T));//]@xNg
	//ڋԂɕϊ
	float3 E = (EyePos-Pos).xyz;
	Out.E.x = dot(E,T);
	Out.E.y = dot(E,B);
	Out.E.z = dot(E,Nor);
	float3 L = -normalize(LightDir).xyz;
	Out.L = mul(L, mWVP);
	
	Out.N = mul(Nor,mWVP);
	//_PʂŌvZƂ
	Out.Col  = Col;//max(0,dot(-LightDir,Nor))*0.8f+amb;
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	//float3 N = 2.0f*tex2D(Samp1,In.Tex1).rgb-1.0f;// @}bv̖@
	float3 R = normalize(reflect(-In.E, In.N));
	float4 ref = max(0,dot(R, In.L));//ʔ
	float4 col = max(0,dot(In.L,In.N))*In.Col*0.3f + float4(0.1,0.1,0.1,1) + 0.1*pow(ref, 8);
	col.a = 1.0f;
	return col;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS();
	}
}