float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 EyePos;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1		:	TEXCOORD1;
	float3 L		:	COLOR0;//CgxNg
	float4 Col		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	float4 amb = {0.2f,0.2f,0.2f,1.0f};
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Tex0 = Tex0;
	//float3 eye = normalize(EyePos - Pos);
	//float3 R = -eye + 2.0f*dot(Nor,eye)*Nor;
	Out.Tex1 = float2((Nor.x-0.5f)*0.5f, (Nor.y-0.5f)*0.5f);
	Out.L	 = -LightDir;//CgxNg
	Out.Col  = max(0,dot(LightDir,mul(Nor,mWVP)))+amb;
	return Out;
}

PixelShader PS = asm
{
		ps_1_1

		; 
		def     c0,       0.2f, 0.2f, 0.2f, 1.0f

		tex     t0                                      ; Xe[WÕeNX`̐F
		tex     t1                                      ; Xe[WP̃eNX`̐F

		; @}bvƃCgxNgƂ̓
		dp3_sat		r1,			v0_bx2,			t1_bx2
		
		; eNX`Ƃďo
		mul		    r0,         r1,         t0

		; Kp
		mul			r0.rgb,		    r0,         v1
		+mov		r0.a,			v1
};

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = <PS>;
	}
}