float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = Clamp;
	AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1		:	TEXCOORD1;
	float2 Tex2		:	TEXCOORD2;
	float2 Tex3		:	TEXCOORD3;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Tex0 = Tex0;
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	return tex2D(Samp0,In.Tex0);
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}