float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1		:	TEXCOORD1;
	float2 Tex2		:	TEXCOORD2;
	float2 Tex3		:	TEXCOORD3;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	//eNX`Aj[V
	float cs = cos(0.05f*AnimTime);
	float sn = sin(0.05f*AnimTime);
	Out.Tex0 = Tex0*0.8f + float2(-cs,-sn) + float2(-0.3, -0.2);
	Out.Tex1 = Tex0*0.8f + float2( sn, cs) + float2(0.1, -0.3);
	Out.Tex2 = Tex0*0.8f + float2( sn,-cs) + float2(-0.1, 0.2);
	Out.Tex3 = Tex0*0.8f + float2(-cs, sn) + float2(0.2, 0.1);
	
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float4 tex1,tex2;
	tex1 = (tex2D(Samp0,In.Tex0) + tex2D(Samp0,In.Tex1))*0.5f;
	tex2 = (tex2D(Samp0,In.Tex2) + tex2D(Samp0,In.Tex3))*0.5f;
	return (tex1+tex2)*0.8f;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}