float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;


sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	AddressU = Clamp;
	AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1x	:	TEXCOORD1;
	float2 Tex1y	:	TEXCOORD2;
	float4 Col		:	COLOR0;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	Out.Col = Col;//mul(Nor,mWVP);
	
	//texture animation
	Out.Tex0 = Tex0;
	float wrt = 1.0f - Col.a;
	Out.Tex1x = (Tex1*0.5f + float2(-0.5f,-0.5f))*wrt + float2(0.3, 0.2);
	Out.Tex1y = (Tex1*0.5f + float2(-0.5f, 0.5f))*wrt;
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float3 bumpX = 0.5f*tex2D(Samp1,In.Tex1x)-0.25f;
	float3 bumpY = 0.5f*tex2D(Samp1,In.Tex1y)-0.25f;
	float3 bump = (bumpX+bumpY);
	float4 tex;
	tex = tex2D(Samp0,In.Tex0+bump*0.05f);
	tex.a *= In.Col.a;
	return tex;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_4 PS();
	}
}