/*
	TUNAMI Shader V2.0
	coded by kioku@System K
*/

float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1x	:	TEXCOORD1;
	float2 Tex1y	:	TEXCOORD2;
	float3 E		:	TEXCOORD3;
	float3 N		:	COLOR0;
	float4 L		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	float3 YVec  = {0.01f,1.0f,0.01f};//Y dir vector
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
	
	//calc tangent vector
	float3 B = normalize(cross(Nor,YVec));
	float3 T = normalize(cross(B,Nor));
	B = normalize(cross(Nor,T));
	//tranlate tanget vector
	float3 E = (EyePos-Pos).xyz;
	Out.E.x = dot(E,T);
	Out.E.y = dot(E,B);
	Out.E.z = dot(E,Nor);
	float3 L = -normalize(LightDir).xyz;
	Out.L.x = dot(L,T);
	Out.L.y = dot(L,B);
	Out.L.z = dot(L,Nor);
	
	Out.N = mul(Nor,mWVP);
	//texture animation
	Out.Tex0 = Tex0;
	Out.Tex1x = Tex1*4.0f + float2(AnimTime*0.01f, -AnimTime*0.5f);
	Out.Tex1y = Tex1*4.0f + float2(-AnimTime*0.01f,-AnimTime*0.5f);
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float3 bumpX = 2.0f*tex2D(Samp1,In.Tex1x)-1.0f;
	float3 bumpY = 2.0f*tex2D(Samp1,In.Tex1y)-1.0f;
	float3 bump = normalize(bumpX+bumpY);
	float4 tex;
	tex = tex2D(Samp0,In.Tex0 + bump.xy*0.5f);
	tex *= max(0,dot(In.N,In.L))*0.3f + 0.7f;
	tex.a = 0.85f;
	return tex;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_2_0 PS();
	}
}