/*
    Tunami shader V1.1
    coded by kioku@System K
    2005/3/22
*/
float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1x	:	TEXCOORD1;
	float2 Tex1y	:	TEXCOORD2;
	float3 E		:	TEXCOORD3;
	float4 Col		:	COLOR0;
	float3 L		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);

	//texture animation
	Out.Tex0  = Tex0 + float2(0.0f,-1.0f*AnimTime);
	Out.Tex1x = Tex1*2.0f + float2(0.05f*AnimTime,0.05f*AnimTime) + float2(0.3, 0.2);
	Out.Tex1y = Tex1*2.0f + float2(-0.05f*AnimTime,-0.05f*AnimTime);
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float4 bump1 = tex2D(Samp1,In.Tex1x);
	float4 bump2 = tex2D(Samp1,In.Tex1y);
	float4 bump = bump1 + bump2 -0.50f;
	float4 color = tex2D(Samp0,In.Tex0) * (bump*0.3f+0.2) +  float4(0.3f,0.3f,0.3f,1.0f);
	color = color + color*color*color*color;
	color.a =0.85f;
	return color;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}