/*
	TUNAMI Shader V1.4
	coded by kioku@System K
*/

float4x4 mWVP;
texture Texture0;
texture Texture1;
float3 LightDir;
float3 LightPos;
float3 EyePos;
float AnimTime;

sampler Samp0 = sampler_state
{
	Texture = <Texture0>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};
sampler Samp1 = sampler_state
{
	Texture = <Texture1>;
	MinFilter = LINEAR;
	MagFilter = LINEAR;
	MipFilter = NONE;
	//AddressU = Clamp;
	//AddressV = Clamp;
};

struct VS_OUTPUT
{
	float4 Pos		:	POSITION;
	float2 Tex0		:	TEXCOORD0;
	float2 Tex1x	:	TEXCOORD1;
	float2 Tex1y	:	TEXCOORD2;
	float3 E		:	TEXCOORD3;
	float3 N		:	COLOR0;
	float3 L		:	COLOR1;
};

VS_OUTPUT VS(
	float4 Pos		:	POSITION,
	float4 Col		:	COLOR,
	float3 Nor		:	NORMAL,
	float2 Tex0		:	TEXCOORD0,
	float2 Tex1		:	TEXCOORD1
){
	VS_OUTPUT Out =  (VS_OUTPUT) 0;
	Out.Pos = mul(Pos,mWVP);
		
	//texture animation
	Out.Tex0 = Tex0;
	Out.Tex1x = Tex1 + float2(AnimTime*0.01f, -AnimTime*0.5f);
	Out.Tex1y = Tex1 + float2(-AnimTime*0.01f,-AnimTime*0.5f);
	return Out;
}

float4 PS(VS_OUTPUT In) : COLOR
{
	float3 bumpX = 0.50f*tex2D(Samp1,In.Tex1x)-0.25f;
	float3 bumpY = 0.50f*tex2D(Samp1,In.Tex1y)-0.25f;
	float3 bump = bumpX + bumpY;
	float4 tex;
	tex = tex2D(Samp0,In.Tex0 + bump.xy*0.5f)*0.8f;
	tex.a = 1;
	return tex;
}

technique TShader
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_4 PS();
	}
}