/* 45 minute surprise coding compo at remedy 2005 by gamkiller of Introx 
 * gcc speedhack.c -Wall -o surprise `sdl-config --cflags --libs` */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <SDL/SDL.h>

#define STARNUM 500
  
SDL_Surface *screen;

  SDL_Surface *backdrop;
  SDL_Surface *logo;
void plot(SDL_Surface * surface, int xx, int yy, Uint32 pix){
  Uint8 *p = (Uint8 *) surface->pixels + yy * surface->pitch + xx;
  *p = pix;
}
Uint8 getp(SDL_Surface * surface, int x, int y)
{                  
    SDL_LockSurface(surface);
    Uint8 *p = (Uint8 *) surface->pixels + x + (y * surface->pitch);
    SDL_UnlockSurface(surface);
    return *p;
}  

void scale(SDL_Surface * out, short x0, short y0,short x1, short y1){
  float xstep, ystep, xratio, yratio;
  short xdiff, ydiff;
  short xcount, ycount;
  int color;
      
  ydiff = y1 - y0; 
  xdiff = x1 - x0; 
          
  xratio = (float) 244 / xdiff;
  yratio = (float) 62 / ydiff;
    
  for (ystep = 0, ycount = y0; ycount < (ydiff + y0);ystep += yratio, ycount++) {
    for (xstep = 0, xcount = x0; xcount < (xdiff + x0);xstep += xratio, xcount++) {
      color = getp(logo, (int)xstep, (int)ystep);
        plot(screen, (int)xcount, (int)ycount, color);
    }
  }
}

void blit(SDL_Surface *surface, int x, int y){
  SDL_Rect dest;
  dest.x = x;
  dest.y = y;
  SDL_UnlockSurface(surface);
  SDL_BlitSurface(surface, NULL, screen, &dest);
}


int main(void){
  short busy;
  SDL_Rect dest;
  SDL_Event event;
  
  struct starEx{
    float x;
    int y;
    float layer;
    int c;
  } stars[STARNUM];

  int i;
  int move;
  int movex;
  
  /* sdl quickinit */
  SDL_Init(SDL_INIT_VIDEO);
  atexit(SDL_Quit);
  screen = SDL_SetVideoMode(640, 480, 8, SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_HWPALETTE|SDL_FULLSCREEN);
										    
  if(!screen){
    printf("failed to allocate memory for video!\n");
    exit(1);
  }
  SDL_ShowCursor(SDL_DISABLE);

  backdrop = SDL_LoadBMP("back2.bmp");
  logo = SDL_LoadBMP("hax_remedy2.bmp");
  if(!logo){
    printf("POO\n");
  }

  for(i = 0; i < STARNUM; i++){
    stars[i].x = rand()%639;
    stars[i].y = rand()%479;
    stars[i].layer = rand()%3 + 1;
    stars[i].c = 0;
  }

  move = 0;
  movex = 1;
  busy = 1;

  while(busy){
    while(SDL_PollEvent(&event))
      if(event.type == SDL_KEYDOWN)
	if(event.key.keysym.sym == SDLK_ESCAPE)
	  busy = 0; /* Wee! */
  
    /*blit(backdrop, 0, 0);*/
    memcpy(screen->pixels, backdrop->pixels, (640*480));
    
    scale(logo, 0, 0, 640, move);
    move+=movex;
    if(move > 150 || move < 1)
      movex = -movex;
    
    for(i = 0; i < STARNUM; i++){
      plot(screen, (int)stars[i].x, stars[i].y, stars[i].c);
      plot(screen, (int)stars[i].x+1, stars[i].y, stars[i].c);
      plot(screen, (int)stars[i].x, stars[i].y+1, stars[i].c);
      plot(screen, (int)stars[i].x+1, stars[i].y+1, stars[i].c);

      stars[i].x -= stars[i].layer;
      if(stars[i].x < 0){
	stars[i].x = 639 - stars[i].x;
	stars[i].y = rand()%479;
	stars[i].layer = rand()%3 + 1;
      }
    }
      
  
    SDL_Flip(screen);
  }
		
  return 0;

}
