/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class FrameworkCanvas
extends Canvas {
    final int UP_VALUE;
    final int DOWN_VALUE;
    final int LEFT_VALUE;
    final int RIGHT_VALUE;
    final int DEAD;
    final int IN_PLAY;
    final int SPLASH_SCREEN;
    final int CHANGING_LEVEL;
    final int GAME_CLEARED;
    final int GAME_STORY;
    final int GAME_CONTROLS;
    int gameStatus;
    int timestep;
    int screenWidth;
    int screenHeight;
    ScubaZed spritePlayer;
    Sprite selector;
    int direction;
    AbstractLevel gameLevel;
    int level;
    int score;
    long time;
    boolean upOn;
    boolean downOn;
    boolean leftOn;
    boolean rightOn;
    boolean fireOn;

    FrameworkCanvas(int timestep) {
        this.UP_VALUE = 1;
        this.DOWN_VALUE = 2;
        this.LEFT_VALUE = 3;
        this.RIGHT_VALUE = 4;
        this.DEAD = 1;
        this.IN_PLAY = 2;
        this.SPLASH_SCREEN = 3;
        this.CHANGING_LEVEL = 4;
        this.GAME_CLEARED = 5;
        this.GAME_STORY = 6;
        this.GAME_CONTROLS = 7;
        this.timestep = timestep;
        this.screenWidth = this.getWidth();
        this.screenHeight = this.getHeight();
        this.direction = 5;
        this.score = 0;
        this.gameStatus = 3;
        this.level = 1;
        this.gameLevel = new Level1Impl();
        try {
            this.selector = new Sprite(Image.createImage((String)"/selector.png"), 10, 10);
            this.selector.setPosition(70, 225);
            this.spritePlayer = new ScubaZed(Image.createImage((String)"/scubazed.png"), 10, 20);
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            this.spritePlayer.setFrameSequence(nArray);
            this.spritePlayer.setPosition(this.gameLevel.getStartPosX(), this.gameLevel.getStartPosY());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void move() {
        if (this.gameStatus == 2) {
            if (this.upOn) {
                this.spritePlayer.move(0, -4);
                this.direction = 1;
            } else if (this.downOn) {
                this.spritePlayer.move(0, 4);
                this.direction = 2;
            } else if (this.rightOn) {
                this.spritePlayer.move(4, 0);
                this.direction = 4;
            } else if (this.leftOn) {
                this.spritePlayer.move(-4, 0);
                this.direction = 3;
            }
            if (this.fireOn && this.gameLevel.getBlinks() > 0) {
                this.spritePlayer.setFrameSequence(new int[]{3});
                this.spritePlayer.nextFrame();
                this.repaint();
                long now = System.currentTimeMillis();
                while (now + 100L > System.currentTimeMillis()) {
                }
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                this.spritePlayer.setFrameSequence(nArray);
                switch (this.direction) {
                    case 1: {
                        this.spritePlayer.move(0, -50);
                        break;
                    }
                    case 2: {
                        this.spritePlayer.move(0, 50);
                        break;
                    }
                    case 4: {
                        this.spritePlayer.move(50, 0);
                        break;
                    }
                    case 3: {
                        this.spritePlayer.move(-50, 0);
                    }
                }
                this.gameLevel.removeBlinks();
                this.fireOn = false;
            }
            if (System.currentTimeMillis() > this.time + 500L) {
                this.time = System.currentTimeMillis();
                this.updateFrames();
                if (this.gameLevel.removeTime()) {
                    this.isHit();
                }
            }
            this.gameLevel.moveObjects();
            this.checkOutOfBounds();
            this.gameLevel.checkCollisions(this.spritePlayer, this.direction);
            this.gameLevel.checkCollisionsNeutral(this.spritePlayer);
            if (this.gameLevel.checkCollissionsDanger(this.spritePlayer)) {
                this.isHit();
            }
            if (this.gameLevel.checkCollisionsKey(this.spritePlayer)) {
                ++this.level;
                this.nextLevel();
            }
        } else if (this.gameStatus == 4) {
            if (this.fireOn) {
                this.gameStatus = 2;
                long now = System.currentTimeMillis();
                while (now + 500L > System.currentTimeMillis()) {
                }
                MidletFramework.vibrate(500);
            }
        } else if (this.gameStatus == 3) {
            if (this.fireOn) {
                if (this.selector.getY() == 225) {
                    this.gameStatus = 2;
                    long now = System.currentTimeMillis();
                    while (now + 500L > System.currentTimeMillis()) {
                    }
                    MidletFramework.vibrate(500);
                } else if (this.selector.getY() == 245) {
                    this.gameStatus = 7;
                    long now = System.currentTimeMillis();
                    while (now + 200L > System.currentTimeMillis()) {
                    }
                } else {
                    this.gameStatus = 6;
                    long now = System.currentTimeMillis();
                    while (now + 200L > System.currentTimeMillis()) {
                    }
                }
            }
            if (this.downOn) {
                if (this.selector.getY() != 265) {
                    this.selector.move(0, 20);
                } else {
                    this.selector.setPosition(this.selector.getX(), 225);
                }
            } else if (this.upOn) {
                if (this.selector.getY() != 225) {
                    this.selector.move(0, -20);
                } else {
                    this.selector.setPosition(this.selector.getX(), 265);
                }
            }
        } else if (this.gameStatus == 6 || this.gameStatus == 7) {
            if (this.fireOn) {
                this.gameStatus = 3;
            }
        } else if (this.fireOn) {
            this.reset();
        }
    }

    private void reset() {
        this.direction = 5;
        this.score = 0;
        this.gameStatus = 3;
        this.level = 1;
        this.gameLevel = new Level1Impl();
        this.spritePlayer.setLives(3);
        this.spritePlayer.setPosition(this.gameLevel.getStartPosX(), this.gameLevel.getStartPosY());
    }

    private void isHit() {
        MidletFramework.vibrate(100);
        this.spritePlayer.setFrameSequence(new int[]{4});
        this.spritePlayer.setFrame(0);
        this.repaint();
        long now = System.currentTimeMillis();
        while (now + 100L > System.currentTimeMillis()) {
        }
        if (this.spritePlayer.removeLives()) {
            this.gameOver();
        } else {
            this.restartLevel();
        }
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.spritePlayer.setFrameSequence(nArray);
    }

    private void nextLevel() {
        this.score += 100;
        this.score += 10 * this.gameLevel.getTime();
        this.score += this.gameLevel.getBonus();
        switch (this.level) {
            case 2: {
                this.gameLevel = new Level2Impl();
                break;
            }
            case 3: {
                this.gameLevel = new Level3Impl();
                break;
            }
            case 4: {
                this.gameLevel = new Level4Impl();
                break;
            }
            default: {
                this.gameLevel = new Level1Impl();
            }
        }
        this.gameStatus = 4;
        this.restartLevel();
    }

    private void restartLevel() {
        this.gameLevel.resetBlinks();
        this.gameLevel.resetTime();
        this.score -= 10;
        if (this.score < 0) {
            this.score = 0;
        }
        this.spritePlayer.setPosition(this.gameLevel.getStartPosX(), this.gameLevel.getStartPosY());
        long now = System.currentTimeMillis();
        while (now + 500L > System.currentTimeMillis()) {
        }
    }

    private void gameOver() {
        this.gameStatus = 1;
    }

    private void checkOutOfBounds() {
        if (this.spritePlayer.getX() <= 10) {
            this.spritePlayer.setPosition(10, this.spritePlayer.getY());
        }
        if (this.spritePlayer.getX() + 20 >= this.getWidth()) {
            this.spritePlayer.setPosition(this.getWidth() - 20, this.spritePlayer.getY());
        }
        if (this.spritePlayer.getY() <= 10) {
            this.spritePlayer.setPosition(this.spritePlayer.getX(), 10);
        }
        if (this.spritePlayer.getY() >= this.getHeight() - 80) {
            this.spritePlayer.setPosition(this.spritePlayer.getX(), this.getHeight() - 80);
        }
    }

    private void updateFrames() {
        this.gameLevel.updateFrames();
        this.spritePlayer.nextFrame();
    }

    public void paint(Graphics g) {
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        switch (this.gameStatus) {
            case 2: {
                this.gameLevel.paint(g);
                g.setColor(100, 100, 100);
                g.fillRect(0, 0, this.screenWidth, 10);
                g.fillRect(0, 0, 10, this.screenHeight - 60);
                g.fillRect(0, this.screenHeight - 60, this.screenWidth, 10);
                g.fillRect(this.screenWidth - 9, 0, 10, this.screenHeight - 50);
                g.setColor(255, 255, 255);
                this.spritePlayer.paint(g);
                g.translate(0, this.screenHeight - 100);
                g.drawString("Time " + this.gameLevel.getTime(), 10, 60, 20);
                g.drawString("Score " + this.score, 100, 60, 20);
                g.drawString("Zaps " + this.gameLevel.getBlinks(), 180, 60, 20);
                g.drawString("Lives left: " + this.spritePlayer.getLives(), 10, 80, 20);
                g.drawString("Level: " + this.level, 100, 80, 20);
                break;
            }
            case 1: {
                this.gameLevel.paint(g);
                g.setColor(100, 100, 100);
                g.fillRect(0, 0, this.screenWidth, 10);
                g.fillRect(0, 0, 10, this.screenHeight - 60);
                g.fillRect(0, this.screenHeight - 60, this.screenWidth, 10);
                g.fillRect(this.screenWidth - 9, 0, 10, this.screenHeight - 50);
                g.translate(0, this.screenHeight - 100);
                g.setColor(0, 0, 0);
                g.fillRect(50, 0, 100, 20);
                g.setColor(255, 255, 255);
                g.drawString("Game Over :(", 100, 0, 17);
                g.drawString("Time " + this.gameLevel.getTime(), 10, 60, 20);
                g.drawString("Score " + this.score, 100, 60, 20);
                g.drawString("Zaps " + this.gameLevel.getBlinks(), 180, 60, 20);
                g.drawString("Lives left: " + this.spritePlayer.getLives(), 10, 80, 20);
                g.drawString("Level: " + this.level, 100, 80, 20);
                break;
            }
            case 3: {
                g.setColor(255, 255, 255);
                try {
                    g.drawImage(Image.createImage((String)"/splash.png"), 0, 0, 0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.selector.paint(g);
                g.translate(120, this.screenHeight - 90);
                g.drawString("ScubaZed 2 - ScubaZed goes dungeon", 0, 0, 17);
                g.drawString("Start the game", 0, 20, 17);
                g.drawString("Controls", 0, 40, 17);
                g.drawString("The story", 0, 60, 17);
                break;
            }
            case 4: {
                if (this.level == 5) {
                    this.gameStatus = 5;
                }
                g.setColor(255, 255, 255);
                g.translate(100, this.screenHeight - 100);
                g.drawString("Level cleared, press fire to play level: " + this.level, 0, 0, 17);
                break;
            }
            case 5: {
                g.setColor(255, 255, 255);
                g.translate(120, this.screenHeight - 80);
                g.drawString("You have cleared ScubaZed 2", 0, 0, 17);
                g.drawString("Your final score was: " + this.score, 0, 20, 17);
                g.drawString("Press fire to restart the game", 0, 40, 17);
                break;
            }
            case 7: {
                g.setColor(255, 255, 255);
                g.drawString("ScubaZed 2 - Controls", 0, 0, 20);
                g.drawString("Use the controlpad to navigate through the", 0, 40, 20);
                g.drawString("dungeon with ScubaZed", 0, 60, 20);
                g.drawString("To use ScubaZed's special zap skill who", 0, 100, 20);
                g.drawString("teleports him a short distance, make sure", 0, 120, 20);
                g.drawString("you are facing the right direction and press fire.", 0, 140, 20);
                g.drawString("Notice: this special skill can only be used", 0, 180, 20);
                g.drawString("once per level so be smart and careful to", 0, 200, 20);
                g.drawString("get out of the dungeon. For great justice!", 0, 220, 20);
                break;
            }
            case 6: {
                g.setColor(255, 255, 255);
                g.drawString("Previously, ScubaZed defeated all the", 0, 0, 20);
                g.drawString("waterenemies. In the last battle against the", 0, 20, 20);
                g.drawString("infamous Hurumhai, ScubaZed got a nasty blow", 0, 40, 20);
                g.drawString("to the head, but fortunately he recovered", 0, 60, 20);
                g.drawString("and defeated Hurumhai. After the battle, ", 0, 80, 20);
                g.drawString("because of the blow, ScubaZed fell unconcious.", 0, 100, 20);
                g.drawString("Now, he has awoken in a mysterious dungeon,", 0, 120, 20);
                g.drawString("without his ultimate gun of waterenemy", 0, 140, 20);
                g.drawString("destruction, but with a new skill, and a new", 0, 160, 20);
                g.drawString("divingsuit :D. Is Hurumhai behind all this?", 0, 180, 20);
                g.drawString("Was he really defeated? Or is there a new ", 0, 200, 20);
                g.drawString("enemy about? And will ScubaZed be able to", 0, 220, 20);
                g.drawString("escape the dungeon? It's all up to you to", 0, 240, 20);
                g.drawString("take off every ScubaZed! For great justice!", 0, 260, 20);
            }
        }
    }

    protected void keyPressed(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.upOn = true;
                this.downOn = false;
                break;
            }
            case 6: {
                this.downOn = true;
                this.upOn = false;
                break;
            }
            case 2: {
                this.leftOn = true;
                this.rightOn = false;
                break;
            }
            case 5: {
                this.rightOn = true;
                this.leftOn = false;
                break;
            }
            case 8: {
                this.fireOn = true;
            }
        }
    }

    protected void keyReleased(int keyCode) {
        switch (this.getGameAction(keyCode)) {
            case 1: {
                this.upOn = false;
                break;
            }
            case 6: {
                this.downOn = false;
                break;
            }
            case 2: {
                this.leftOn = false;
                break;
            }
            case 5: {
                this.rightOn = false;
                break;
            }
            case 8: {
                this.fireOn = false;
            }
        }
    }
}

