
/************************************************************************/
/*                                                                      */
/* This file contains declarations that are used both by the HH game    */
/* and external DLL libraries.                                          */
/* Include this file in your code when writing a custom HH DLL.         */
/*                                                                      */
/* You should leave this file unchanged.                                */
/*                                                                      */
/************************************************************************/

#ifndef DLL_COMMON_INCLUDED
#define DLL_COMMON_INCLUDED

// This structure contains information passed to frame_bg and
// frame_fg in the FX DLL.
struct FX_FrameInfo
{
    double time_elapsed;                // game-milliseconds elapsed since last frame. to get 'realtime', divide this by speed_factor!
    int num_players;                    // number of players in current game (2 or 4)
    bool first_frame;                   // this is the first frame in a match
    int ball_x, ball_y;                 // position of ball (in pixels, center of ball)
    float ball_angle;                   // rotation angle of the ball (counterclockwise,degrees)
    float ball_lvelx, ball_lvely;       // linear velocity of the ball
    float ball_ang_vel;                 // angular velocity of the ball
    int p0_x, p0_y;                     // position of player 0 (left side, in pixels, center of player)
    int p1_x, p1_y;                     // position of player 1 (right side, in pixels, center of player)
    int p2_x, p2_y;                     // position of player 2 (valid if num_players==4)
    int p3_x, p3_y;                     // position of player 3 (valid if num_players==4)
    float p0_velx, p0_vely;             // player 0 velocity
    float p1_velx, p1_vely;             // player 1 velocity
    float p2_velx, p2_vely;             // player 2 velocity (valid if num_players==4)
    float p3_velx, p3_vely;             // player 3 velocity (valid if num_players==4)
    int p0_ctrl, p1_ctrl;               // current controls for player 0 and 1: bit0=left, bit1=right, bit2=jump
    int p2_ctrl, p3_ctrl;               // same for player 2 and 3, valid only if num_players==4
    int left_score, right_score;        // score for left and right player(s)
    int serving_side;                   // 0=left side serving, 1=right side serving
    int rally_state;                    // 0=before serving, ball sitting still. 1=playing. 2=rally finished, but ball still jumping around
    bool rally_state_changed;           // true if the rally state has changed in the current frame. useful for events like sounds etc..
    int s0_touched, s1_touched;         // how many times has left/right side touched the ball? (>=4 --> foul)
    const char* p0_name;                // player name for player 0
    const char* p1_name;                // player name for player 1
    const char* p2_name;                // player name for player 2 (valid only if num_players==4)
    const char* p3_name;                // player name for player 3 (valid only if num_players==4)
    unsigned char s0_r, s0_g, s0_b;     // desired color for left side texts (such as score)
    unsigned char s1_r, s1_g, s1_b;     // desired color for right side texts (such as score)
    unsigned char msg_r, msg_g, msg_b;  // color for in-game message texts
    unsigned char win_r, win_g, win_b;  // color used for displaying the winner screen text
    unsigned char mc_r, mc_g, mc_b;     // color used for menu captions
    unsigned char mi_r, mi_g, mi_b;     // color used for menu items
    unsigned char msi_r, msi_g, msi_b;  // color used for selected menu items
    int pcoll_x, pcoll_y;               // ball/player collision coordinates, in pixels. valid if at least one coord is >= 0.
    int ncoll_x, ncoll_y;               // ball/net collision coordinates, in pixels. valid if at least one coord is >= 0.
    int gcoll_x, gcoll_y;               // ball/ground collision coordinates, in pixels. valid if at least one coord is >= 0.
    int wcoll_x, wcoll_y;               // ball/wall collision coordinates, in pixels. valid if at least one coord is >= 0.    
    float speed_factor;                 // (adaptive) speed factor. 1.0 = normal speed.

    char reserved[128];                 // unused reserved space for future use.
};


// Key constants, for mouse and keyboard keys queried by the DLL.
enum {
    HH_K_UNKNOWN,
    HH_K_ESC,
    HH_K_F1,
    HH_K_F2,
    HH_K_F3,
    HH_K_F4,
    HH_K_F5,
    HH_K_F6,
    HH_K_F7,
    HH_K_F8,
    HH_K_F9,
    HH_K_F10,
    HH_K_F11,
    HH_K_F12,
    HH_K_PRINT,
    HH_K_SCROLL,
    HH_K_PAUSE,
    HH_K_0,
    HH_K_1,
    HH_K_2,
    HH_K_3,
    HH_K_4,
    HH_K_5,
    HH_K_6,
    HH_K_7,
    HH_K_8,
    HH_K_9,
    HH_K_BACKSPACE,
    HH_K_TAB,
    HH_K_A,
    HH_K_B,
    HH_K_C,
    HH_K_D,
    HH_K_E,
    HH_K_F,
    HH_K_G,
    HH_K_H,
    HH_K_I,
    HH_K_J,
    HH_K_K,
    HH_K_L,
    HH_K_M,
    HH_K_N,
    HH_K_O,
    HH_K_P,
    HH_K_Q,
    HH_K_R,
    HH_K_S,
    HH_K_T,
    HH_K_U,
    HH_K_V,
    HH_K_W,
    HH_K_X,
    HH_K_Y,
    HH_K_Z,
    HH_K_RETURN,
    HH_K_SHIFT,
    HH_K_CAPSLOCK,
    HH_K_CTRL,
    HH_K_ALT,
    HH_K_ALTGR,
    HH_K_SPACE,
    HH_K_PERIOD,
    HH_K_COMMA,
    HH_K_INSERT,
    HH_K_DELETE,
    HH_K_HOME,
    HH_K_END,
    HH_K_PGUP,
    HH_K_PGDN,
    HH_K_LEFT,
    HH_K_RIGHT,
    HH_K_UP,
    HH_K_DOWN,
    HH_K_MINUS,
    HH_K_PLUS,
    HH_K_NUM_DIV,
    HH_K_NUM_MUL,
    HH_K_NUM_MINUS,
    HH_K_NUM_PLUS,
    HH_K_NUM_RETURN,
    HH_K_NUM_0,
    HH_K_NUM_1,
    HH_K_NUM_2,
    HH_K_NUM_3,
    HH_K_NUM_4,
    HH_K_NUM_5,
    HH_K_NUM_6,
    HH_K_NUM_7,
    HH_K_NUM_8,
    HH_K_NUM_9,
    HH_K_NUM_COMMA,
    HH_K_TILDE,
    HH_K_SLASH,
    HH_K_BACKSLASH,  // this is the "console" key left to the one
    HH_K_COLON,
    HH_K_SQBRCK_OP,  // square bracket open
    HH_K_SQBRCK_CL,  // square bracket close
    HH_K_QUOTES,

    // mouse
    HH_M_BUTTON1,
    HH_M_BUTTON2,
    HH_M_BUTTON3,
    HH_M_WHEELUP,
    HH_M_WHEELDN,

    // This must be the last entry
    HH_NUM_DIGITALCONTROLS
};


#endif