/************************************************************************/
/*                                                                      */
/* This file contains code that initializes the pointers                */
/* for the utility functions made available by Hairy Harry.             */
/* Please link to this module when writing your own fx dll.             */
/*                                                                      */
/* You should leave this file unchanged.                                */
/*                                                                      */
/************************************************************************/

#include "fxdll.h"

fp_image_load                   image_load;
fp_image_free                   image_free;
fp_image_getinfo                image_getinfo;
fp_image_data                   image_data;
fp_sprite_load                  sprite_load;
fp_sprite_free                  sprite_free;
fp_sprite_render                sprite_render;
fp_sprite_getinfo               sprite_getinfo;
fp_font_load                    font_load;
fp_font_free                    font_free;
fp_font_render                  font_render;
fp_font_gen_char_rects          font_gen_char_rects;
fp_font_get_text_extent         font_get_text_extent;
fp_sound_load                   sound_load;
fp_sound_free                   sound_free;
fp_sound_play                   sound_play;
fp_key_down                     key_down;
fp_key_pressed                  key_pressed;
fp_get_mouse_move               get_mouse_move;
fp_hhlog                        hhlog;
fp_get_physparm                 get_physparm;


DLL_EXPORT void init_fx_dll (
    fp_image_load                   _image_load,
    fp_image_free                   _image_free,
    fp_image_getinfo                _image_getinfo,
    fp_image_data                   _image_data,
    fp_sprite_load                  _sprite_load,
    fp_sprite_free                  _sprite_free,
    fp_sprite_render                _sprite_render,
    fp_sprite_getinfo               _sprite_getinfo,
    fp_font_load                    _font_load,
    fp_font_free                    _font_free,
    fp_font_render                  _font_render,
    fp_font_gen_char_rects          _font_gen_char_rects,
    fp_font_get_text_extent         _font_get_text_extent,
    fp_sound_load                   _sound_load,
    fp_sound_free                   _sound_free,
    fp_sound_play                   _sound_play,
    fp_key_down                     _key_down,
    fp_key_pressed                  _key_pressed,
    fp_get_mouse_move               _get_mouse_move,
    fp_hhlog                        _hhlog,
    fp_get_physparm                 _get_physparm
    )
{
    image_load              = _image_load;
    image_free              = _image_free;
    image_getinfo           = _image_getinfo;
    image_data              = _image_data;
    sprite_load             = _sprite_load;
    sprite_free             = _sprite_free;
    sprite_render           = _sprite_render;
    sprite_getinfo          = _sprite_getinfo;
    font_load               = _font_load;
    font_free               = _font_free;
    font_render             = _font_render;
    font_gen_char_rects     = _font_gen_char_rects;
    font_get_text_extent    = _font_get_text_extent;
    sound_load              = _sound_load;
    sound_free              = _sound_free;
    sound_play              = _sound_play;
    key_down                = _key_down;
    key_pressed             = _key_pressed;
    get_mouse_move          = _get_mouse_move;
    hhlog                   = _hhlog;
    get_physparm            = _get_physparm;    
}

