#pragma once
namespace PPK {

enum {
	WAVETABLE_SIZE	=	4 * 1024 * 1024,

	SAMPLE_RATE		= 44100,
	PITCH_SHIFT 	= 14,
	L1				= 96,
	NOTE_WIDTH		= 96,
	LEN_WIDTH		= 96,
	VOL_SHIFT		= 5,
	VOL_WIDTH		= 1<<VOL_SHIFT,
	VOL_MAX			= VOL_WIDTH-1,
	GATE_SHIFT		= 4,
	GATE_WIDTH		= 1<<GATE_SHIFT,
	EG_SHIFT		= 17,
	EG_MAX			= (1<<EG_SHIFT)-1,
	INSTRUMENT_MAX	= 495,
	SUSTAIN_MAX		= 32767,
	LFO_SHIFT		= 8,

	REG_TIME = 0,
	REG_LENGTH,
	REG_TEMPO,
	REG_DETUNE,
	REG_INSTRUMENT,
	REG_VOLUME,
	REG_GATERATIO,
	REG_PITCH_BASE,
	REG_PITCH,
	REG_PITCH_SRC,
	REG_NOTE,

	REG_KEYTIME,
	REG_KEYOFF,
	REG_EG_OUTPUT,
	REG_LFO_VAL,
	REG_SAMPLE_POS,
	REG_KEY,

	REG_ENV_ATTACK_TIME,
	REG_ENV_DECAY_TIME,

	REG_ENV_ATTACK_RATE,
	REG_ENV_DECAY_RATE,
	REG_ENV_SUSTAIN_RATE,
	REG_ENV_RELEASE_RATE,

	REG_LFO_DELAY,
	REG_LFO_DEPTH,
	REG_LFO_RATE,
	REG_LFO_DV,
	REG_KEYSCALE,
	REG_OUTPUT_MAX,
	REG_ENDPTR,
	REG_QUIT,
	REG_WIDTH,

#ifdef PPK_USE_FILTER
	REG_FILTER_BUF_0 = REG_QUIT,
	REG_FILTER_BUF_1 = REG_OUTPUT_MAX,
#endif

	REG_SPAN		= REG_WIDTH,
	LEN_SPAN		= LEN_WIDTH+1,
	NOTE_SPAN		= NOTE_WIDTH,

	CMD_TOP_DUMMY	= -1,
	REG_TOP,
	REG_END			= REG_TOP + REG_SPAN - 1,
	LEN_TOP,
	LEN_END			= LEN_TOP + LEN_SPAN - 1,
	SLUR,
	REST,
	NOTE_TOP,
	NOTE_END		= NOTE_TOP + NOTE_SPAN - 1,
	CMD_END,

	CENTER_NOTE		= 4 * 12,
	DETUNE_ZERO		= (-CENTER_NOTE*64) + (PITCH_SHIFT*12*64),
};

#ifdef PPK_STATIC_FORCE_INLINE
static __forceinline
#endif
void sequencer(short* render_buffer, short* render_buffer_end, char* wavetable_buf, const unsigned char* pattern);

} // namespace ppk
