/*
 * Star Trek code for Alchimie 6 invitation
 * (c) 2006, Francois Revol <revol@free.fr>
 */

#include <lib.h>

#include "invit.h"

#define DELAY 50
#define DELAY2 30
#define DELAY3 100


#define STAT_X 10
#define STAT_Y 2
#define STAT_LINES 5

#define LCARS_LEFT_W 10

#define C_SF_L 126
#define C_SF_R 127

#define VID_X 19
#define VID_Y 13
#define VID_W 16
#define VID_H 8

void show_stats_toblack(void)
{
  char *s = (char *)TEXTVRAM + STAT_Y * NCOL + STAT_X;
  char *p, *q;
  char l, x;
  char w, c;
  
  //p = s + STAT_LINES * NCOL + 1;
  //*p = 'X';
  
  for (p = s, l = STAT_LINES; l; p+=NCOL, l--) {
    *p = A_FWBLACK;
    spin(DELAY);
  }
}

void show_stats_new(void)
{
  char *s = (char *)TEXTVRAM + STAT_Y * NCOL + STAT_X;
  char *p, *q;
  char l, x;
  char w, c;
  
  //p = s + STAT_LINES * NCOL + 1;
  //*p = 'X';
  
  for (p = s, l = STAT_LINES; l; p+=NCOL, l--) {
    w = myrand() & 3;
    for (x = 1; x < NCOL - STAT_X; x++) {
      if (w) {
	w--;
	c = ' ';
      } else {
	c = myranddigit();
      }
      if (x==4 || x==10 || x==14 || x==19 || x==22 || x==27) {
	c = ' ';
	w = myrand() & 3;
      }
      *(p+x) = c;
    }
  }
  for (p = s, l = STAT_LINES; l; p+=NCOL, l--) {
    *p = A_FWYELLOW;
    spin(DELAY);
  }
}

void show_stats_replace(void)
{
  show_stats_toblack();
  show_stats_new();
}

void show_stats_scan(void)
{
  char *s = (char *)TEXTVRAM + STAT_Y * NCOL + STAT_X;
  char *p, *q;
  char l, x;
  char w, c;

  //p = s + STAT_LINES * NCOL + 1;
  //*p = 'X';
  
  p = s;
  *p = A_FWWHITE;
  q = p+NCOL;
  spin(DELAY2);
  *q = A_FWWHITE;
  //q+=NCOL;
  //*q = A_FWWHITE;
  spin(DELAY2);
  *p = A_FWYELLOW;
  //p+=NCOL;
  for (q = p+NCOL*2, l = STAT_LINES-1; l; p+=NCOL, q+=NCOL, l--) {
    if (l > 1)
      *q = A_FWWHITE;
    *p = A_FWYELLOW;
    spin(DELAY2);
  }
  *p = A_FWYELLOW;
}

void show_stats(void)
{
  static char cycle = 0;
  if (!cycle)
    show_stats_replace();
  else
    show_stats_scan();
  cycle = (cycle + 1) & 0x3;
}

void draw_lcars_line(char x, char y, char len, char color, char *label)
{
  char *p = (char *)TEXTVRAM + x + y * NCOL;
  *p = A_FWBLACK;
  p[1] = color + A_BGBLACK;
  memset(p+2, ' ', len-2);
  p[len-1] = A_BGBLACK;
  if (label) {
    len -= strlen(label);
    len--;
    p += len;
    while (*label)
      *p++ = *label++;
  }
}

void draw_lcars_btn_1(char x, char y, char len, char height, char color, char *label)
{
  while (--height)
    draw_lcars_line(x, y++, len, color, NULL);
  draw_lcars_line(x, y, len, color, label);
}

void draw_lcars_btn_2(char x, char y, char len, char height, char color, char *label)
{
  draw_lcars_line(x, y++, len, color, label);
  while (--height)
    draw_lcars_line(x, y++, len, color, NULL);
}

/* extends down */
void draw_lcars_btn_ed(char x, char y, char len, char height, char extralen, char color, char *label)
{
  draw_lcars_line(x, y++, len, color, label);
  height--;
  while (--height)
    draw_lcars_line(x, y++, len, color, NULL);
  draw_lcars_line(x, y, extralen, color, NULL);
  draw_lcars_line(x+extralen, y, 10, A_FWWHITE, NULL);
  draw_lcars_line(x+extralen+10, y, NCOL-extralen-x-9, color, NULL);
  /* fancy rounding */
  putat(x,y,color);
  putat(x+1,y,'{'+1);
  putat(x+2,y,A_BGBLACK+color);
  //y--;
  //putat(x+len-1,y,color);
  //putat(x+len,y,'{');
  //putat(x+len+2,y,A_BGBLACK);

}

/* extends up */
void draw_lcars_btn_eu(char x, char y, char len, char height, char extralen, char color, char *label)
{
  draw_lcars_line(x+extralen+10, y, NCOL-extralen-x-9, color, NULL);
  draw_lcars_line(x+extralen, y, 10, A_FWWHITE, NULL);
  draw_lcars_line(x, y, extralen, color, NULL);
  /* fancy rounding */
  putat(x,y,color);
  putat(x+1,y,'{'+2);
  putat(x+2,y,A_BGBLACK+color);
  y++;
  height--;
  while (--height)
    draw_lcars_line(x, y++, len, color, NULL);
  draw_lcars_line(x, y, len, color, label);
}

void draw_lcars_btn_r(char x, char y, char len, char color, char *label)
{
  draw_lcars_line(x+2, y, len, color, label);
  putat(x,y,color);
  putat(x+1,y,123);
  putat(x+2,y,A_BGBLACK+color);
  putat(x+3,y,A_FWBLACK);
}

void setup_lcars(void)
{
  // nice Starfleet logo
  putat(NCOL-3,27,A_FWYELLOW);
  putat(NCOL-2,27,C_SF_L);
  putat(NCOL-1,27,C_SF_R);
  delay(1);
  // menu
  draw_lcars_btn_1( 0, 0, LCARS_LEFT_W, 3,     A_FWMAGENTA, "SYSTEM");
  draw_lcars_btn_ed(0, 4, LCARS_LEFT_W, 4, 20, A_FWCYAN,      "STAT");
  
  delay(1);
  // clear status line
  // hack (overwrite msg but not the menu)
  status_out(' ', "                ");

  show_stats();
  show_stats_toblack();

  draw_lcars_btn_eu(0, 9, LCARS_LEFT_W, 4, 20, A_FWRED,      "VIDEO");
  draw_lcars_btn_1(0, 14, LCARS_LEFT_W, 3,     A_FWYELLOW, "ST. MAP");
  draw_lcars_btn_1(0, 18, LCARS_LEFT_W, 3,     A_FWYELLOW, "NGC-117");
  draw_lcars_btn_1(0, 22, LCARS_LEFT_W, 3,     A_FWYELLOW, "USS-XXX");
  draw_lcars_btn_1(0, 26, LCARS_LEFT_W, 2,     A_FWCYAN,      "EXIT");
  // buttons
  draw_lcars_btn_r(10, 11, 7, A_FWYELLOW, "STOP");
  draw_lcars_btn_r(10, 13, 7, A_FWYELLOW, "PLAY");
  draw_lcars_btn_r(10, 15, 7, A_FWYELLOW, "DISP");
  delay(1);
}

void setup_lcars_2(void)
{
  draw_lcars_btn_eu(0, 9, LCARS_LEFT_W, 4, 20, A_FWMAGENTA,   "TEXT");
  draw_lcars_btn_r(10, 11, 7, A_FWYELLOW, "PGUP");
  draw_lcars_btn_r(10, 13, 7, A_FWYELLOW, "PGDN");
  draw_lcars_btn_r(10, 15, 7, A_FWYELLOW, "HOME");
  draw_lcars_line(30, 9, 5, A_FWMAGENTA, NULL);
  draw_lcars_line(35, 9, 6, A_FWYELLOW, "1/3");
}

void setup_video(void)
{
  char i, j;
  for (i = 0; i < VID_H; i++)
    putat(VID_X+1, VID_Y+i, A_ALT);
  for (i = 0; i < VID_H; i++)
    putat(VID_X, VID_Y+i, A_FWWHITE);
  draw_lcars_btn_r(10, 13, 7, A_FWMAGENTA, "PLAY");
}

void uninit_video(void)
{
  char i, j;
  draw_lcars_btn_r(10, 13, 7, A_FWYELLOW, "PLAY");
  draw_lcars_btn_r(10, 11, 7, A_FWMAGENTA, "STOP");
  for (i = 0; i < VID_H; i++) {
    for (j = VID_X; j < VID_X+2+VID_W; j++)
      putat(j, VID_Y+i, ' ');
  }
  spin(50);
  draw_lcars_btn_r(10, 11, 7, A_FWYELLOW, "STOP");
}

void display_random_frame()
{
  char i, j;
  for (i = 0; i < VID_H; i++) {
    for (j = VID_X+2; j < VID_X+2+VID_W; j++)
      putat(j, VID_Y+i, myrandc());
  }
}

void display_frame(char *f)
{
  char i, j, k = 0;
  for (i = 0; i < VID_H; i++) {
    for (j = VID_X+2; j < VID_X+2+VID_W; j++)
      putat(j, VID_Y+i, f[k++]);
  }
}

void do_random_video(void)
{
  char n = 20;
  while(n--)
    display_random_frame();
}

void do_video(void)
{
  char n = 100;
  char i;
  char *f;
  while(n--) {
    i = myrand() & 0x7; /* 1 of 8 frames */
    f = frame1 + VID_W * VID_H * i;
    display_frame(f);
  }
}

void do_music_1(void)
{
  char i;
  /* XXX: I suck at music :)*/
  char vol = 14;
  char oct = 3;
  
  show_stats_replace();
  play(1,0,0,0);
  
  for (i = 12; i; i--) {
    music(1,oct+2,i,vol-5);
    spin(5);
  }
  for (i = 12; i; i--) {
    music(1,oct+1,i,vol-3);
    spin(5);
  }
  for (i = 12; i; i--) {
    music(1,oct,i,vol-1);
    spin(5);
  }
  
  music(1,oct,4,vol);
  //spin(200);
  show_stats_scan();
  //spin(200);
  music(1,oct,11,vol);
  spin(50);
  music(1,oct+1,4,vol);
  spin(50);
  music(1,oct+1,2,vol);
  show_stats_scan();
  spin(100);
  //spin(200);

  music(1,oct,11,vol);
  spin(50);
  music(1,oct+1,6,vol);
  spin(50);
  music(1,oct+1,4,vol);
  show_stats_scan();
  //spin(200);
  spin(100);

  music(1,oct+1,2,vol);
  spin(50);
  music(1,oct+1,4,vol);
  spin(50);
  music(1,oct+1,6,vol);
  spin(50);
  music(1,oct+1,2,vol);
  spin(50);
  music(1,oct+1,4,vol);
  show_stats_scan();
  spin(50);
  music(1,oct+1,2,vol);
  spin(200);
  music(1,oct+1,1,vol);
  spin(200);
  
#if 0  
  
  music(1,oct,3,vol);
  //spin(200);
  show_stats_scan();
  //spin(200);
  music(1,oct,8,vol);
  spin(50);
  music(1,oct+1,1,vol);
  spin(50);
  music(1,oct,11,vol);
  show_stats_scan();
  //spin(200);
  //spin(200);

  music(1,oct,8,vol);
  spin(50);
  music(1,oct+1,3,vol);
  spin(50);
  music(1,oct+1,1,vol);
  show_stats_scan();
  //spin(200);
  spin(200);

  music(1,oct,11,vol);
  spin(50);
  music(1,oct+1,1,vol);
  spin(50);
  music(1,oct+1,3,vol);
  spin(50);
  music(1,oct,11,vol);
  spin(50);
  music(1,oct+1,1,vol);
  show_stats_scan();
  //spin(200);
  music(1,oct,11,vol);
  spin(200);
  music(1,oct,10,vol);
  spin(200);
  
#endif
  /* another theme */
  /*
  
  music(1,oct,1,vol);
  spin(200);
  music(1,oct,3,vol);
  spin(50);
  music(1,oct+1,1,vol);
  spin(50);
  music(1,oct,3,vol);
  spin(200);
  music(1,oct,1,vol);
  spin(50);
  music(1,oct+1,3,vol);
  spin(50);
  music(1,oct,1,vol);
  spin(200);
  */

  music(1,0,0,0);
  music(0,0,0,0);
  play(0,0,0,0);
  play(1,0,0,0);
  play(0,0,0,0);
  /* bloody NTVDM stays noisy... */
  kbdclick1();
  /**/

}

void do_startrek_screen(void)
{
  char i;
  //do_music_1();

  // clear status line
  memset(TEXTVRAM,' ',NCOL*1);
  status_out(A_FWYELLOW, "BOOTING LCARS...");
  // install font
  memcpy((char *)STDCHRTABLE+123*8,STFont,(int)(STFontEnd-STFont));
  
  cls();
  paper(A_FWBLACK);
  ink(A_FWGREEN);
  poke(TEXTVRAM,A_BGBLACK);
  poke(TEXTVRAM+1,A_FWGREEN); // ink() doesn't set status line...
  setup_lcars();

  do_music_1();

  dbl_text_out(10, 0, A_FWWHITE, "ENCRYPTED VIDEO TRANSMISSION");
  


  dbl_text_out(14, 24, A_FWYELLOW, "INITIATING TRANSMISSION");
  setup_video();
  show_stats();
  do_random_video();
  show_stats();
  dbl_text_out(13, 24, A_FWYELLOW, "ESTABLISHED TRANSMISSION");
  
  do_video();
  spin(200);
  uninit_video();
  dblblk_text_out(13, 24, A_FWYELLOW, "    END TRANSMISSION    ");
  dbl_text_out(10, 0, A_FWWHITE, "                            ");
  show_stats();
  show_stats();
  dbl_text_out(10, 0, A_FWWHITE, " ENCRYPTED TEXT TRANSMISSION");
  setup_lcars_2();
  show_stats();
  show_stats();
  
  dbl_text_out(24,12, A_FWWHITE, "URGENT MESSAGE");
  dbl_text_out(23,14, A_FWWHITE, "FROM STARFLEET:");
  for (i = 16; i < 27; i++)
    putat(10, i, A_FWYELLOW);
  spin(DELAY3);
  i = 17;
  text_out(11,i++, "You are expected to attend");
  text_out(11,i++, "Alchimie 6, located in ");
  text_out(11,i++, "Tain l'Hermitage (France),");
  spin(DELAY3);
  text_out(11,i++, "on earth (alpha quadrant). ");
  text_out(11,i++, "                            ");
  spin(DELAY3);
  text_out(11,i++, "The meeting is scheduled for");
  // cf. http://www.hillschmidt.de/gbr/sternenzeit.htm
  text_out(11,i++, "stardate -316196.23         ");
  text_out(11,i++, "(October 21 2006, 9h)       ");
  text_out(11,i++, "for 3 days.                 ");
  text_out(11,i++, "                            ");

  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  draw_lcars_btn_r(10, 13, 7, A_FWMAGENTA, "PGDN");
  show_stats();
  draw_lcars_btn_r(10, 13, 7, A_FWYELLOW,  "PGDN");
  show_stats();
  draw_lcars_line(35, 9, 6, A_FWYELLOW, "2/3");
  
  i = 17;
  text_out(11,i++, "Agenda:                     ");
  spin(DELAY3);
  text_out(11,i++, " - Demo contests for Amiga, ");
  text_out(11,i++, "   TI92,and other platforms,");
  spin(DELAY3);
  text_out(11,i++, " - Wild compositions for all");
  text_out(11,i++, "   platforms,               ");
  spin(DELAY3);
  text_out(11,i++, " - Conferences: AmigaOS 4,  ");
  text_out(11,i++, "   Haiku, LUnix NG for ORIC,");
  text_out(11,i++, "   MorphOS, DADVSI/EUCD,    ");
  text_out(11,i++, "   FPGAs, Free Software...  ");
  text_out(11,i++, "                            ");
  spin(DELAY3);

  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  draw_lcars_btn_r(10, 13, 7, A_FWMAGENTA, "PGDN");
  show_stats();
  draw_lcars_btn_r(10, 13, 7, A_FWYELLOW,  "PGDN");
  show_stats();
  draw_lcars_line(35, 9, 6, A_FWYELLOW, "3/3");
  
  i = 17;
  text_out(11,i++, "You can find more infos at: ");
  spin(DELAY3);
  text_out(11,i++, "http://triplea.fr/alchimie6/");
  text_out(11,i++, "                            ");
  spin(DELAY3);
  text_out(11,i++, "                            ");
  spin(DELAY3);
  text_out(11,i++, "                            ");
  spin(DELAY3);
  text_out(11,i++, "Looking forward to see you. ");
  spin(DELAY3);
  text_out(11,i++, "                            ");
  text_out(11,i++, "        Cap. Jean-Luc Picard.");
  text_out(11,i++, "                            ");

  show_stats();
  show_stats();
  show_stats();
  show_stats();
  delay(10);
  show_stats();
  show_stats();
  show_stats();
  show_stats();
  delay(10);
  show_stats();
  show_stats();
  show_stats();
  show_stats();

  // clear
  draw_lcars_line(35, 9, 6, A_FWYELLOW, NULL);
  for (i=12; i<16; i++)
    text_out(23,i, "                 ");
  for (i=17; i<27; i++) {
    spin(DELAY3);
    text_out(11,i, "                             ");
  }
  

  show_stats();
  show_stats();
  delay(10);
  show_stats();
  show_stats();

  show_stats_toblack();
}
