#ifndef encyclopedia_h
#define encyclopedia_h

//############################################################################
// Include ###################################################################
//############################################################################

#include "eventhandler.h"

#include "libfhi.h"

//############################################################################
// Define ####################################################################
//############################################################################

// Forward declaration.
class EncyclopediaPage;

//############################################################################
// Class #####################################################################
//############################################################################

/** Encyclopedia allows the user to browse data about the game world. It is
 * it's own event handler.
 */
class Encyclopedia :
  public EventHandler,
  public libfhi::Singleton<Encyclopedia>
{
  private:
    /** All the pages in the encyclopedia. */
    std::vector<EncyclopediaPage*> pages;

    /** Current page. */
    int current_page;

    /** The PostModel. */
    libfhi::PostModel *model;

  public:
    Encyclopedia();
    virtual ~Encyclopedia();

  private:
    void add(const char*);

    // Virtual methods.
  public:
    virtual void draw(libfhi::Surface*);
    virtual void keydown(int);
    virtual void keyup(int);
    virtual void return_to();
    virtual void tick();

  public:
    inline libfhi::PostModel* get_model();
};

//############################################################################
// Inline ####################################################################
//############################################################################

/** Get the current angles of this.
 * @return angle pointer.
 */
libfhi::PostModel* Encyclopedia::get_model()
{
  return this->model;
}

//############################################################################
// End #######################################################################
//############################################################################

#endif

