#ifndef libfhi_camera_include
#define libfhi_camera_include

//############################################################################
// Includet ##################################################################
//############################################################################

#include "libfhi_orientation.h"

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

class Camera : public Orientation
{
  private:
    Matrix44 vm;

  public:
    Camera();
    Camera(uint16_t, uint16_t, uint16_t, float, float, float);
    Camera(uint16_t, uint16_t, uint16_t, const Vector3&);
    virtual ~Camera();

    void copy(Camera *);

    // Virtual functions.
    virtual void tick();

    // Inline functions.
    inline const Matrix44& get_vm() const;
};

//############################################################################
// Getters ###################################################################
//############################################################################

/** Get the view matrix for camera transformations.
 * @return The view matrix.
 */
const Matrix44& Camera::get_vm() const
{
  return this->vm;
}

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

