#ifndef libfhi_texture_include
#define libfhi_texture_include

//############################################################################
// Include ###################################################################
//############################################################################

#include "libfhi_canonicaldb.h"

#ifdef LIBFHI_OPENGL
#include LIBFHI_GLEW_H
#endif

namespace libfhi {

//############################################################################
// Luokka ####################################################################
//############################################################################

/** Texture represents one texture available in-game. They are saved in a
 * canonical db and automatically generated and compiled to OpenGL texture
 * names.
 *
 * As of now, there is no software texture support, textured polygons will be
 * drawn as just gouraud-shaded if in software mode.
 *
 * What this means, is that when compiling without OpenGL support, the texture
 * class will be essentially empty.
 */
class Texture :
  public CanonicalDB<Texture>
{
  public:
    /** Create an OpenGL texture. */
    static const uint8_t KEEP_OPENGL = 0x01;

    /** Save the bitmap data. */
    static const uint8_t KEEP_DATA = 0x02;

  private:
#ifdef LIBFHI_OPENGL
    /** Texture index. */
    GLuint texture_name;
#endif

#ifdef LIBFHI_PNG
    /** Png data. */
    LIBFHI_PNG_BYTE *data;
#endif

    /** Width. */
    int width;

    /** Height. */
    int height;

    /** Bit depth. */
    int bpp;

  public:      
    Texture();
    Texture(const char*);
    ~Texture();

    bool load(const char*, uint8_t = KEEP_OPENGL);

    // Inline.
  public:
#ifdef LIBFHI_OPENGL
    inline GLuint get_texture_name() const;
#endif
#ifdef LIBFHI_PNG
    inline LIBFHI_PNG_BYTE* get_data();
#endif
    inline int get_b() const;
    inline int get_h() const;
    inline int get_w() const;
};

//############################################################################
// Functions #################################################################
//############################################################################

extern Texture* texture_new(const char*);

//############################################################################
// Inline ####################################################################
//############################################################################

#ifdef LIBFHI_OPENGL
/** Return the texture name in OpenGL
 * @return Texture name.
 */
GLuint Texture::get_texture_name() const
{
  return this->texture_name;
}
#endif

#ifdef LIBFHI_PNG
/** Return the color array.
 * @return Pointer to the beginning of the color array.
 */
LIBFHI_PNG_BYTE* Texture::get_data()
{
  return this->data;
}
#endif

/** Return the bit depth.
 * @return Value as int.
 */
int Texture::get_b() const
{
  return this->bpp;
}

/** Return the height.
 * @return Value as int.
 */
int Texture::get_h() const
{
  return this->height;
}

/** Return the width.
 * @return Value as int.
 */
int Texture::get_w() const
{
  return this->width;
}

//############################################################################
// Loppu #####################################################################
//############################################################################

}
#endif

