//###########################################################################
// Definet ##################################################################
//###########################################################################

// On / off
//#define DEBUG
#define SHOW_INFO
//#define SHOW_INTERPOLATION_TABLES
#define SHOW_TIME
//#define WAIT

// Arvoja
#define TEST_SPAN		(15 * 1000)

//###########################################################################
// Includet #################################################################
//###########################################################################

#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "libfhi.h"

#include "SDL.h"

//###########################################################################
// Vakiot ###################################################################
//###########################################################################

const uint32_t
  TIMER_MILLISECONDS = 13;

const float
  HMAP_PLANAR_SCALE = 65000.0,
  HMAP_HEIGHT_SCALE = 15000.0,
  TIMER_FPS = 1000.0f / static_cast<float>(TIMER_MILLISECONDS);

//###########################################################################
// Globaalit ################################################################
//###########################################################################

SDL_Event event;
bool draw_bool = false;
extern int i_asm[10];
extern float f_asm[10];
int loop_control = 1, tricords[8];
libfhi::Vector3 tricolors[4];
libfhi::Font *vera;


// 3D-kama
libfhi::Camera camera;
libfhi::LightDirectional light;
libfhi::PostModel *malli = NULL;
std::string modelview;

//###########################################################################
// generoi_pyramidi #########################################################
//###########################################################################

static const float PYRAMID_SIZE = 10.0f;
static const libfhi::Color4 PYRAMID_COLOR(1.0f, 0.24f, 0.24f, 1.0f);

/** Generate a pyramid (for tests).
 * @return PostModel of that pyramid.
 */
libfhi::PostModel* generoi_pyramidi()
{
  
  libfhi::PreModel *mdl = libfhi::PreModel::canon_get("pyramidi");
  if(mdl == NULL)
  {
    mdl = libfhi::PreModel::canon_new("pyramidi");

    // Stuff vertices.
    mdl->add_vertex(
	libfhi::Vector3(0.0f, PYRAMID_SIZE, 0.0f),
	PYRAMID_COLOR, libfhi::Vector2(0.0f, 0.0f));
    mdl->add_vertex(
	libfhi::Vector3(PYRAMID_SIZE, -PYRAMID_SIZE, -PYRAMID_SIZE),
	PYRAMID_COLOR, libfhi::Vector2(0.0f, 0.0f));
    mdl->add_vertex(
	libfhi::Vector3(-PYRAMID_SIZE, -PYRAMID_SIZE, -PYRAMID_SIZE),
	PYRAMID_COLOR, libfhi::Vector2(0.0f, 0.0f));
    mdl->add_vertex(
	libfhi::Vector3(-PYRAMID_SIZE, -PYRAMID_SIZE, PYRAMID_SIZE),
	PYRAMID_COLOR, libfhi::Vector2(0.0f, 0.0f));
    mdl->add_vertex(
	libfhi::Vector3(PYRAMID_SIZE, -PYRAMID_SIZE, PYRAMID_SIZE),
	PYRAMID_COLOR, libfhi::Vector2(0.0f, 0.0f));
    // Stuff faces.
    mdl->add_face(0, 1, 2);
    mdl->add_face(0, 2, 3);
    mdl->add_face(0, 3, 4);
    mdl->add_face(0, 4, 1);
    mdl->add_face(4, 3, 2, 1);
  
    // Display generated pyramid.
    //std::cout << *mdl << "\n";
  }

  // Compile.
  libfhi::Mesh *mesh = libfhi::Mesh::canon_get("pyramidi");
  if(mesh == NULL)
  {
    mesh = mdl->compile("pyramidi");
  }

  // Adapt and return.
  libfhi::PostModel *ret = new libfhi::PostModel(mesh);
  //std::cout << *ret << "\n";
  return ret;
}

//###########################################################################
// Generoi tunnelia #########################################################
//###########################################################################

static const int
  TUNNELI_COMPLEXITY = 32,
  TUNNELI_TUBES = 128;

static const float
  TUNNELI_BIGRADIUS = 2200.0,
  TUNNELI_RADIUS = 140.0;

/** Generate a polygon tunnel for tests.
 * @return PostModel of the tunnel.
 */
libfhi::PostModel* generoi_tunneli(bool wireframe)
{

  libfhi::PreModel *mdl = libfhi::PreModel::canon_get("tunneli");
  if(mdl == NULL)
  {
    mdl = libfhi::PreModel::canon_new("tunneli");

    libfhi::Vector3 *tunnelcenters = new libfhi::Vector3[TUNNELI_TUBES];
    float *tunneljitter_plane = new float[TUNNELI_TUBES],
	  *tunneljitter_height = new float[TUNNELI_TUBES];
  
    // Ladotaan tunnelien keskukset xy-tasoon
    for(int i = 0; i < TUNNELI_TUBES; ++i)
    {
      libfhi::Vector3 *ver = &tunnelcenters[i];
      float tubefii, tubecosc, tubesinc;

      tunneljitter_plane[i] = tunneljitter_height[i] = 0.0f;

      tubefii = static_cast<float>(i) / static_cast<float>(TUNNELI_TUBES) *
	2 * static_cast<float>(M_PI);
      tubecosc = cos(tubefii);
      tubesinc = sin(tubefii);

      ver->f[0] = tubecosc * (TUNNELI_BIGRADIUS - tunneljitter_plane[i] *
	  TUNNELI_RADIUS);
      ver->f[2] = tubesinc * (TUNNELI_BIGRADIUS - tunneljitter_plane[i] *
	  TUNNELI_RADIUS);
      ver->f[1] = tunneljitter_height[i] * TUNNELI_RADIUS;

      // Tehdään samalla verteksit tälle renkaalle
      for(int j = 0; j < TUNNELI_COMPLEXITY; ++j)
      {
	float fii, cosc, sinc;
	
	fii = static_cast<float>(j) / static_cast<float>(TUNNELI_COMPLEXITY) *
	  2 * static_cast<float>(M_PI);
	cosc = cos(fii);
	sinc = sin(fii);

	libfhi::Vector3 temp_vector(
	    ver->xf + (TUNNELI_RADIUS * cosc) * tubecosc,
    	    ver->yf + TUNNELI_RADIUS * sinc,
	    ver->zf + (TUNNELI_RADIUS * cosc) * tubesinc);

	libfhi::Color4 tunnelcolor(
	    static_cast<float>(rand() % 256) / 255.0f,
    	    static_cast<float>(rand() % 256) / 255.0f,
	    static_cast<float>(rand() % 256) / 255.0f,
	    1.0f);

	mdl->add_vertex(temp_vector, tunnelcolor,
	    libfhi::Vector2(0.0f, 0.0f));
      }
    }

    // Kasvojen aika
    for(int i = 0; i < TUNNELI_TUBES; ++i)
    {
      int j = i + 1,
	  ring1,
	  ring2;

      if(j >= TUNNELI_TUBES)
      {
	j = 0;
      }
      ring1 = i * TUNNELI_COMPLEXITY;
      ring2 = j * TUNNELI_COMPLEXITY;

      for(int k = 0; k < TUNNELI_COMPLEXITY; ++k)
      {
	int l = k+1;

	if(l >= TUNNELI_COMPLEXITY)
	{
  	  l = 0;
	}

	mdl->add_face(ring2 + k, ring1 + l, ring1 + k);
	mdl->add_face(ring2 + l, ring1 + l, ring2 + k);
      }
    }

    delete[] tunnelcenters;
    delete[] tunneljitter_plane;
    delete[] tunneljitter_height;
  }

  // Compile.
  libfhi::Mesh *mesh;
  if(wireframe)
  {
    mesh = libfhi::Mesh::canon_get("wiretunneli");
    if(mesh == NULL)
    {
      mdl->attr_or(libfhi::PreModel::ATTR_WIREFRAME);
      mesh = mdl->compile("wiretunneli");
    }
  }
  else
  {
    mesh = libfhi::Mesh::canon_get("tunneli");
    if(mesh == NULL)
    {
      mesh = mdl->compile("tunneli");
    }
  }

  return new libfhi::PostModel(mesh);
} 

//###########################################################################
// Take input ###############################################################
//###########################################################################

int get_SDL_input()
{
  int i;

  for(i=0; SDL_PollEvent(&event); i++)
  {
    switch(event.type)
    {
      // Nappi painetaan
      case SDL_KEYDOWN:
	switch(event.key.keysym.sym)
	{
	  // Hallinta
	  case SDLK_ESCAPE:
	    loop_control = 0;
	    break;
	  case SDLK_p:
	  case SDLK_PRINT:
	    if(loop_control == 1)
	      loop_control = 2;
	    else
	      loop_control = 1;
	    break;
	  // Kamera
          case SDLK_KP5:
	    camera.rotation_add(-256, 0, 0);
	    break;
	  case SDLK_KP2:
	    camera.rotation_add(256, 0, 0);
	    break;
	  case SDLK_KP3:
	    camera.rotation_add(0, -256, 0);
	    break;
	  case SDLK_KP1:
	    camera.rotation_add(0, 256, 0);
	    break;
	  case SDLK_KP6:
	    camera.rotation_add(0, 0, -256);
	    break;
	  case SDLK_KP4:
	    camera.rotation_add(0, 0, 256);
	    break;
	  case SDLK_a:
	    camera.movement_add(-0.1f, 0.0f, 0.0f);
	    break;
	  case SDLK_d:
	    camera.movement_add(0.1f, 0.0f, 0.0f);
	    break;
	  case SDLK_q:
	    camera.movement_add(0.0f, -0.1f, 0.0f);
	    break;
	  case SDLK_e:
	    camera.movement_add(0.0f, 0.1f, 0.0f);
	    break;
	  case SDLK_w:
	    camera.movement_add(0.0f, 0.0f, -0.1f);
	    break;
	  case SDLK_s:
	    camera.movement_add(0.0f, 0.0f, 0.1f);
	    break;
	  // Testiobu
          case SDLK_HOME:
	    malli->rotation_add(-256, 0, 0);
	    break;
	  case SDLK_END:
	    malli->rotation_add(256, 0, 0);
	    break;
	  case SDLK_PAGEDOWN:
	    malli->rotation_add(0, -256, 0);
	    break;
	  case SDLK_DELETE:
	    malli->rotation_add(0, 256, 0);
	    break;
	  case SDLK_PAGEUP:
	    malli->rotation_add(0, 0, -256);
	    break;
	  case SDLK_INSERT:
	    malli->rotation_add(0, 0, 256);
	    break;
	  // Sluten.
	  default:
	    break;
	}
	break;
      // Nappi vapautetaan
      case SDL_KEYUP:
	switch(event.key.keysym.sym)
	{
	  // Kamera
	  case SDLK_KP5:
	    camera.rotation_add(256, 0, 0);
	    break;
	  case SDLK_KP2:
	    camera.rotation_add(-256, 0, 0);
	    break;
	  case SDLK_KP3:
	    camera.rotation_add(0, 256, 0);
	    break;
	  case SDLK_KP1:
	    camera.rotation_add(0, -256, 0);
	    break;
	  case SDLK_KP6:
	    camera.rotation_add(0, 0, 256);
	    break;
	  case SDLK_KP4:
	    camera.rotation_add(0, 0, -256);
	    break;
	  case SDLK_a:
	    camera.movement_add(0.1f, 0.0f, 0.0f);
	    break;
	  case SDLK_d:
	    camera.movement_add(-0.1f, 0.0f, 0.0f);
	    break;
	  case SDLK_q:
	    camera.movement_add(0.0f, 0.1f, 0.0f);
	    break;
	  case SDLK_e:
	    camera.movement_add(0.0f, -0.1f, 0.0f);
	    break;
	  case SDLK_w:
	    camera.movement_add(0.0f, 0.0f, 0.1f);
	    break;
	  case SDLK_s:
	    camera.movement_add(0.0f, 0.0f, -0.1f);
	    break;
	    // Testiobu
	  case SDLK_HOME:
	    malli->rotation_add(256, 0, 0);
	    break;
	  case SDLK_END:
	    malli->rotation_add(-256, 0, 0);
	    break;
	  case SDLK_PAGEDOWN:
	    malli->rotation_add(0, 256, 0);
	    break;
	  case SDLK_DELETE:
	    malli->rotation_add(0, -256, 0);
	    break;
	  case SDLK_PAGEUP:
	    malli->rotation_add(0, 0, 256);
	    break;
	  case SDLK_INSERT:
	    malli->rotation_add(0, 0, -256);
	    break;
	  // Slut
	  default:
	    break;
	}
	break;
      default:
	break;
    }
  }

  return i;
}

//###########################################################################
// Timer ####################################################################
//###########################################################################

int framecount, timer_begin;

void timer_start()
{
  timer_begin = SDL_GetTicks();
  framecount = 0;
}

void timer_end()
{
  double ops, difftime;
 
  difftime = static_cast<double>(SDL_GetTicks() - timer_begin) / 1000.0;
  ops = static_cast<double>(framecount) / difftime;
  printf("%i operations done in %i seconds.\nThat means %f operations per second.\n", framecount, static_cast<int>(difftime), ops);
}

//###########################################################################
// Speed test ###############################################################
//###########################################################################

void test_speed(libfhi::Surface *s)
{
  printf("Starting time test.\n");
    
  s->clear(0, static_cast<uint16_t>(libfhi::Boundary::ZBUFFER_MAX));
  s->lock();
  timer_start();
    
  for(; SDL_GetTicks() - timer_begin < TEST_SPAN; framecount++)
  {
    s->nc_line(0, 0, s->get_w() - 1, s->get_h() - 1, 0xFFFFFFFF);
  }
  timer_end();
  s->unlock();
}

//###########################################################################
// 3D test ##################################################################
//###########################################################################

/** Effect for tunnel.
 */
void tunneliefu(uint16_t pos, libfhi::Camera *cam,
    libfhi::LightDirectional *lit, libfhi::PostModel *mdl1,
    libfhi::PostModel *mdl2)
{
  cam->set_pos(TUNNELI_BIGRADIUS, 0, 0);
  cam->set_angles(0, 0, cam->get_zr() + pos);
  lit->set_angles(lit->get_xr() + 2 * pos, lit->get_yr() + 8 * pos, 0);

  mdl1->set_angles(0, mdl1->get_yr() - pos, 0);
  mdl1->set_pos(0.0, 0.0, 0.0);
  mdl2->set_angles(0, mdl2->get_yr() - pos, 0);
  mdl2->set_pos(0.0, 0.0, 0.0);
}

/** Actual 3D test.
 * @param s Print to this surface.
 */
void test_3d(libfhi::Surface *s)
{
  // If we are not modelviewing anything specific, generate our standard
  // triangle.
  if(!malli)
  {
    malli = generoi_pyramidi();
  }
  malli->set_pos(0.0, 0.0, -20.0);
  malli->set_angles(0, 0, 0);

  libfhi::PostModel
    *tunneli = generoi_tunneli(false),
    *wiretunneli = generoi_tunneli(true);

  // Initialize light.
  light.set_pos(1.0f, 0.0f, 0.0f);
  light.set_ambient(0.2f, 0.2f, 0.2f);
  light.set_diffuse(1.0f, 1.0f, 1.0f);

  // Initialize camera.
  camera.set_pos(0.0, 0.0, 0.0);
  camera.set_angles(0, 0, 0);

  if(modelview.size() <= 0)
  {
    timer_start();
  }

  for(uint32_t lasttime = SDL_GetTicks(), currtime; loop_control;)
  {
    // Sleep loop.
    while(true)
    {
      currtime = SDL_GetTicks() - lasttime;

      // If we have time, sleep.
      if(currtime <= TIMER_MILLISECONDS - 10)
      {
	SDL_Delay(10);
      }
      // Otherwise check if need to cancel spin.
      else if(currtime >= TIMER_MILLISECONDS)
      {
	break;
      }
    }

    // Iterate for the missed parts.
    for(; (currtime >= TIMER_MILLISECONDS);
	currtime -= TIMER_MILLISECONDS, lasttime += TIMER_MILLISECONDS)
    {
      get_SDL_input();

      // Update tunnel effect if the model view is off.
      if(modelview.size() <= 0)
      {
	tunneliefu(TIMER_MILLISECONDS, &camera, &light, tunneli, wiretunneli);
	tunneli->tick();
	wiretunneli->tick();
      }
      camera.tick();
      light.tick();
    }

    // Luetaan syöte
    get_SDL_input();

    if(loop_control == 1)
    {
      s->lock();
      s->clear(0, libfhi::Boundary::ZBUFFER_MAX);
      //s->clear(libfhi::Boundary::ZBUFFER_MAX);
      s->set_camera(&camera);
      s->set_light(&light);
     
      // If no modelview mode, draw tunnels.
      if(modelview.size() <= 0)
      {
	// Draw solid tunnel.
	s->set_boundary(0, 0, s->get_w() / 2 - 2, s->get_h() - 1,
	    1.0f, 1.0f, 4000.0f);
	s->select_3d();
	libfhi::Surface::draw_model(tunneli);

	// Draw wire tunnel
	s->set_boundary(s->get_w() / 2 + 1, 0, s->get_w() - 1, s->get_h() - 1,
	    1.0f, 1.0f, 4000.0f);
	s->select_3d();
	libfhi::Surface::draw_model(wiretunneli);

	// Draw separator line
	s->set_boundary();
	s->select_2d();
	libfhi::Surface::rect(s->get_w() / 2 - 1, 0, s->get_w() / 2,
	    s->get_h() - 1, libfhi::Surface::makecol3(100, 100, 100));
      }
      // Otherwise just draw the model.
      else
      {
	s->set_boundary(0, 0, s->get_w() - 1, s->get_h() - 1,
	    1.0f, 1.0f, 4000.0f);
	s->select_3d();
	malli->tick();
        libfhi::Surface::draw_model(malli);	
      }

      s->unlock();
      s->flip();

      if(modelview.size() <= 0)
      {
	framecount++;
	if(SDL_GetTicks() - timer_begin > TEST_SPAN)
	{
	  loop_control = 0;
	}
      }
    }
  }

  if(modelview.size() <= 0)
  {
    timer_end();
  }

  // Delete the reserved stuff
  delete malli;
}

//############################################################################
// Kuvatesti #################################################################
//############################################################################

/** Active loop and wait for a key.
 * @return A numerical value that describes the desire for advancing the test
 *         count or 2 if desire is to quit.
 */
int wait_key()
{
  while(true)
  {
    if(SDL_PollEvent(&event))
      if(event.type == SDL_KEYDOWN)
	switch(event.key.keysym.sym)
	{
	  case SDLK_ESCAPE:
	    return 2;
	  case SDLK_LEFT:
	    return -1;
	  case SDLK_RIGHT:
	    return 1;
	  default:
	    return 0;
	}
  }
}

inline float len2dp2(int ax, int ay, int bx, int by)
{
  float dx = static_cast<float>(bx - ax),
	dy = static_cast<float>(by - ay);
  return dx * dx + dy * dy;
}

/** Run a series of picture tests to determine if the drawing methods work
 * correctly. Utilization is not unlike Allegro from the DOS era.
 */
void test_picture(libfhi::Surface *s)
{
  int xl = - s->get_w() / 4,
      xb = s->get_w() / 4 + s->get_w(),
      yl = - s->get_h() / 4,
      yb = s->get_h() / 4 + s->get_h(),
      xr = xb - xl,
      yr = yb - yl,
      test_num = 0;
  float diam = len2dp2(0, 0, xr / 2, yr / 2),
	xc = xl + static_cast<float>(xr) / 2.0f,
	yc = yl + static_cast<float>(yr) / 2.0f;

  // Select this surface for drawing.
  s->select();
  s->select_2d();

  while(true)
  {
    s->clear();
    switch(test_num)
    {
      // Setpixel
      case 0:
	for(int i = xl; i < xb; ++i)
	  for(int j = yl; j < yb; ++j)
	  {
	    float da = len2dp2(i, j, xl, yl),
		  db = len2dp2(i, j, xb, yl),
		  dc = len2dp2(i, j, xl, yb),
		  dd = len2dp2(i, j, xb, yb),
		  r = (da < dd) ? da : dd,
		  g = (db < dd) ? db : dd,
		  b = (dc < dd) ? dc : dd;
	    r = 1.0f - r / diam;
	    g = 1.0f - g / diam;
	    b = 1.0f - b / diam;
	    r *= 255.0f;
	    g *= 255.0f;
	    b *= 255.0f;
	    if(r < 0.0f)
	      r = 0.0f;
	    if(g < 0.0f)
	      g = 0.0f;
	    if(b < 0.0f)
	      b = 0.0f;
	    //printf("%f, %f, %f\n", r, g, b);
	    s->setpixel(i, j, libfhi::Surface::makecol3(static_cast<int>(r),
		  static_cast<int>(g), static_cast<int>(b)));
	  }
	break;

	// Hline
      case 1:
	for(int i = yl; i < yb; ++i)
	{
	  float progress = (static_cast<float>(i - yl) /
	      static_cast<float>(yr) - 0.5f) * 2.0f;
	  int xm = s->get_w() / 2,
	      x1 = xm -
		static_cast<int>(progress * static_cast<float>(xr / 2)),
	      x2 = xm +
		static_cast<int>(progress * static_cast<float>(xr / 2)),
	      col = static_cast<int>(fabs(progress) * 255.0f);
	  s->hline(x1, x2, i, libfhi::Surface::makecol3(col, col, col));
	}
	break;

	// Vline
      case 2:
	for(int i = xl; i < xb; ++i)
	{
	  float progress = (static_cast<float>(i - xl) /
	      static_cast<float>(xr) - 0.5f) * 2.0f;
	  int ym = s->get_h() / 2,
	      y1 = ym -
		static_cast<int>(progress * static_cast<float>(yr / 2)),
	      y2 = ym +
		static_cast<int>(progress * static_cast<float>(yr / 2)),
	      col = static_cast<int>(fabs(progress) * 255.0f);
	  s->vline(y1, y2, i, libfhi::Surface::makecol3(col, col, col));
	}
	break;

	// Line
      case 3:
	for(float i = 0.0f; i < 1.0f; i += 0.02f)
	{
	  float ib = 0.9f + 0.1f * i;
	  int j = static_cast<int>(i * static_cast<float>(xr)),
	      k = static_cast<int>(ib * static_cast<float>(yr)),
	      l = static_cast<int>(ib * static_cast<float>(xr)),
	      m = static_cast<int>(i * static_cast<float>(yr)),
	      col = static_cast<int>(i * 255.0f);
	  s->line(xl + j, yl, xb, yl + k,
	      libfhi::Surface::makecol3(col, col, 0));
	  s->line(xb, yl + m, xb - l, yb,
	      libfhi::Surface::makecol3(col, 0, col));
	  s->line(xb - j, yb, xl, yb - k,
	      libfhi::Surface::makecol3(0, col, col));
	  s->line(xl, yb - m, xl + l, yl,
	      libfhi::Surface::makecol3(col, col, col));
	}
	break;

	// Rect
      case 4:
	for(float i = 0.0f, k = 0.05f; i < 1.0f; i += k)
	  for(float j = 0.0f; j < 1.0f; j += k)
	  {
	    float l = i + k,
		  m = j + k;
	    int x1 = static_cast<int>(i * xr) + xl,
		x2 = static_cast<int>(l * xr) + xl,
		y1 = static_cast<int>(j * yr) + yl,
		y2 = static_cast<int>(m * yr) + yl;
	    s->rect(x1, y1, x2, y2,
		libfhi::Surface::makecol3(static_cast<int>(i * 255.0f),
		  static_cast<int>(j * 255.0f),
		  static_cast<int>(255.0f - (i + j) * 127.5f)));
	  }
	break;

	// Rect_contour
      case 5:
	for(float i = 0.01f; i < 0.99f; i += 0.01f)
	{
	  float j = 1.0f - i,
		xr2 = xr / 2.0f,
		yr2 = yr / 2.0f;
	  int x1 = static_cast<int>(xc - i * xr2),
	      x2 = static_cast<int>(xc + i * xr2),
	      y1 = static_cast<int>(yc - j * yr2),
	      y2 = static_cast<int>(yc + j * yr2);
	  s->rect_contour(x1, y1, x2, y2,
	      libfhi::Surface::makecol3(static_cast<int>(i * 255.0f),
		static_cast<int>(j * 255.0f),
		static_cast<int>(i * j * 255.0f)));
	}
	break;

	// Flat-triangle
      case 6:
	for(float i = 0.0f; i < 1.0f; i += 0.02f)
	{
	  float j = 0.5f + 0.5f * i,
		k = 1.0f - i,
		x1 = xc - (static_cast<float>(xl) + 0.5f *
		    i * static_cast<float>(xr)),
		y2 = yc - (static_cast<float>(yl) +
		    j * static_cast<float>(yr)),
		x3 = xc - (static_cast<float>(xb) -
		    j * static_cast<float>(xr)),
		y1 = yc - static_cast<float>(yl),
		x2 = xc - static_cast<float>(xb),
		y3 = yc - static_cast<float>(yb);
	  int col = static_cast<int>(i * 255.0f);
	  s->point_begin();
	  s->point_add(xc + k * x1, yc + k * y1);
	  s->point_add(xc + k * x2, yc + k * y2);
	  s->point_add(xc + k * x3, yc + k * y3);
	  s->poly_flat(libfhi::Surface::makecol3(col, col, col));
	}
	break;

	// Gouraud-triangle
      case 7:
	for(float i = 0.0f; i < 0.99f; i += 0.02f)
	{
	  float j = 0.5f + 0.5f * i,
		k = 1.0f - i,
		x1 = xc - (static_cast<float>(xb) -
		    0.5f * i * static_cast<float>(xr)),
		y2 = yc - (static_cast<float>(yb) -
		    j * static_cast<float>(yr)),
		x3 = xc - (static_cast<float>(xl) +
		    j * static_cast<float>(xr)),
		y1 = yc - static_cast<float>(yb),
		x2 = xc - static_cast<float>(xl),
		y3 = yc - static_cast<float>(yl),
	  	r = i * 255.0f,
  		g = i * 255.0f,
  		b = i * j * 255.0f;
	  s->point_begin();
	  s->point_add(xc + k * x1, yc + k * y1,
	      libfhi::Color4(r, 0.0f, 0.0f, 255.0f));
	  s->point_add(xc + k * x2, yc + k * y2,
	      libfhi::Color4(0.0f, g, 0.0f, 255.0f));
	  s->point_add(xc + k * x3, yc + k * y3,
	      libfhi::Color4(0.0f, 0.0f, b, 255.0f));
	  s->poly_gouraud();
	}
	break;

	// Textout
      case 8:
	vera->set_size(36);
	libfhi::Surface::nc_rect(0, 0, s->get_w() - 1, s->get_h() - 1,
	    libfhi::Surface::makecol3(40, 40, 40));
	libfhi::Surface::draw_text(50, 90,
	    libfhi::Surface::makecol3(0xFF, 0xFF, 0xFF),
	    vera, "Hello world in 36px.");
	vera->set_size(12);
	libfhi::Surface::draw_text(70, 320,
	    libfhi::Surface::makecol3(0xFF, 0xFF, 0xFF),
	    vera, "Hello world in 16px.");
	libfhi::Surface::draw_text(305, 410,
	    libfhi::Surface::makecol3(0xFF, 0xCC, 0xFF),
	    vera, "A really long text that shall be clipped (16px).");
	libfhi::Surface::draw_text(30, 440,
	    libfhi::Surface::makecol3(0xFF, 0xFF, 0xFF),
	    vera, "ÅÄÖ - åäö, Россиа (16px).");
	libfhi::Surface::draw_text(290, 155,
	    libfhi::Surface::makecol3(0xFF, 0xFF, 0xFF),
	    vera, "ここは判事とひらがなです　（１６ピクセルス）。");
	break;

      default:
	return;
    }

    s->flip();
    int add = wait_key();
    if(add == 2)
      return;
    test_num += add;
    if(test_num < 0)
    {
      test_num = 0;
    }
    if(test_num > 8)
    {
      test_num = 8;
    }
  }
}

//###########################################################################
// Main #####################################################################
//###########################################################################

int main(int argc, char *argv[])
{
  bool fullscreen = false,
       opengl = false,
       wireframe = false;
  int screen_w = 640,
      screen_h = 480,
      screen_b = 32;
  libfhi::Surface *screen;
  void (*testfunc)(libfhi::Surface*) = NULL;

  // Prepare option getter.
  libfhi::GetOpt *opt = new libfhi::GetOpt(argc, argv);
  opt->add_option("resolution", true, 'r', "r");
  opt->add_option("view", true, 'v', "v");
  opt->add_option("3d", false, '3', "3");
  opt->add_option("fullscreen", false, 'f', "f");
  opt->add_option("help", false, 'h', "h");
  opt->add_option("opengl", false, 'o', "o");
  opt->add_option("picture", false, 'p', "p");
  opt->add_option("speed", false, 's', "s");
  opt->add_option("wireframe", false, 'w', "w");

  // Get the options.
  while(true)
  {
    int option_result = opt->get_opt();

    if(option_result == 0)
    {
      break;
    }

    switch(option_result)
    {
      case '3':
	testfunc = test_3d;
	break;
      case 'f':
	fullscreen = true;
	break;
      case 'h':
	testfunc = NULL;
	opt->close();
	break;
      case 'o':
	opengl = true;
	break;
      case 'p':
	testfunc = test_picture;
	break;
      case 'r':
	sscanf(opt->get_arg(), "%ix%ix%i", &screen_w, &screen_h, &screen_b);
	break;
      case 's':
	testfunc = test_speed;
	break;
      case 'v':
	testfunc = test_3d;
        modelview = opt->get_arg();
        break;
      case 'w':
	wireframe = true;
	break;
      default:
	exit(1);
	break;
    }
  }

  // Get rid of the options.
  delete opt;

  // Jos tarvii usagen
  if(testfunc == NULL)
  {
    std::cout << "Usage: " << argv[0] << " <-3,-p,-s> [-fho] [-r ?x?x?]\n" <<
      "  --fullscreen, -f                Full screen mode\n" <<
      "  --help, -h                      Print this help\n" <<
      "  --opengl, -o                    Use OpenGL\n" <<
      "  --resolution, -r [resolution]   Set resolution to ?x?\n" <<
      "\nThe different tests are mutually exclusive. Select one:\n" <<
      "  --3d, -3                        Run 3D test\n" <<
      "  --picture, -p                   Run picture test\n" <<
      "  --speed, -s                     Run speed test\n" <<
      "\nAdditionally you may do something else:\n" <<
      "  --view, -v [file]               View model from file\n";
    exit(1);
  }

  // Initialize libfhi.
  libfhi::init_libfhi();

  // Load font.
  //vera = libfhi::font_load("data/Bitstream_Vera_Sans.ttf");
  vera = libfhi::font_new("data/KochiMincho.ttf");

  // Random päälle
  srand(1);

  // Varataan
  if(testfunc == test_speed)
  {
    screen = libfhi::sdlsurface_new(screen_w, screen_h, screen_b,
	libfhi::Surface::FLAG_ZBUFFER);
  }
  else if(fullscreen)
  {
    if(opengl)
    {
      screen = libfhi::glsurface_new(screen_w, screen_h, screen_b,
	  SDL_FULLSCREEN);
    }
    else
    {
      screen = libfhi::set_mode(screen_w, screen_h, screen_b,
	  libfhi::Surface::FLAG_ZBUFFER,
	  libfhi::sdlSurface::DEFAULT_SDL_FLAGS | SDL_FULLSCREEN);
    }
  }
  else
  {
    if(opengl)
    {
      screen = libfhi::glsurface_new(screen_w, screen_h, screen_b);
    }
    else
    {
      screen = libfhi::set_mode(screen_w, screen_h, screen_b,
	  libfhi::Surface::FLAG_ZBUFFER,
	  SDL_HWSURFACE | SDL_ASYNCBLIT | SDL_DOUBLEBUF);
    }
  }

  // Only run tests if screen was selected.
  if(screen)
  {
    // Valitaan ja tyhjennetään
    screen->select();
    screen->lock();
    screen->clear();
    screen->unlock();
    screen->set_boundary(1.0f);

    // Load model if sepecified.
    if(modelview.size() > 0)
    {
      libfhi::PreModel *pre = libfhi::PreModel::canon_load(modelview.c_str());

      if(wireframe)
      {
	pre->attr_or(libfhi::PreModel::ATTR_WIREFRAME);
      }

      libfhi::Mesh *msh = pre->compile(modelview.c_str());
      
      if(msh)
      {
  	malli = new libfhi::PostModel(msh);
	malli->set_rotation(libfhi::Orientation::ROTATION_ABSORB);
      }
    }

    // Ajetaan testit
    testfunc(screen);
  }

  // Delete the surface.
  delete screen;

  // Exit.
  libfhi::quit_libfhi();
  exit(0);
}

//###########################################################################
// Loppu ####################################################################
//###########################################################################

