#include "weaponmount.h"

#include "data.h"

//############################################################################
// Construction ##############################################################
//############################################################################

/** Load constructor for new weapon mounts. Be sure to set all variables or
 * using the weapon will either crash or have some very weird properties.
 * @param filename The filename to load from.
 */
WeaponMount::WeaponMount(const char *filename)
  : Attributable(DEFAULT_ATTR), name_width(0)
{
  libfhi::ConfigFile filu(filename);

  if(!filu.is_ok())
  {
    std::cout << "Errot: Could not load weapon info from \"" << filename <<
      "\"\n";
    return;
  }

  while(filu.advance())
  {
    if(filu.has_id_arg("attr", 1))
    {
      this->set_attr(filu.get_int(0));
    }
    // Weapon id.
    else if(filu.has_id_arg("weap", 1))
    {
      this->weapon = Data::load_weap(filu.get_string(0).c_str());
    }
    // Ammo.
    else if(filu.has_id_arg("ammo", 1))
    {
      this->max_ammo = filu.get_int(0);
    }
    // Burst.
    else if(filu.has_id_arg("burst", 1))
    {
      this->burst = filu.get_int(0);
    }
    // Charge.
    else if(filu.has_id_arg("charge", 1))
    {
      this->charge = filu.get_int(0);

      // Also set charge on.
      this->attr_or(ATTR_CHARGE);
    }
    // Drain.
    else if(filu.has_id_arg("drain", 1))
    {
      this->drain = filu.get_int(0);
    }
    // Fade.
    else if(filu.has_id_arg("fade", 1))
    {
      this->fade = filu.get_int(0);

      // Also set fade on.
      this->attr_or(ATTR_FADE);
    }
    // Reload.
    else if(filu.has_id_arg("reload", 1))
    {
      this->reload = filu.get_int(0);
    }
    // Spread.
    else if(filu.has_id_arg("spread", 1))
    {
      this->spread = filu.get_int(0);
    }
    else
    {
      filu.warn_empty();
    }
  }

  std::cout << "Loaded weapon mount \"" << filename << "\"\n";
}

/** Default destructor.
 */
WeaponMount::~WeaponMount()
{
  // Do nothing.
}

//############################################################################
// End #######################################################################
//############################################################################

