/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class Cache {
    private static Hashtable cache = new Hashtable();

    public static void add(String prefix, String name, Object obj) {
        Hashtable<String, Object> hashtable = null;
        if (!cache.containsKey(prefix)) {
            hashtable = new Hashtable<String, Object>();
            cache.put(prefix, hashtable);
        } else {
            hashtable = Cache.get(prefix);
        }
        hashtable.put(name, obj);
    }

    public static void clear() {
        cache.clear();
        System.gc();
    }

    public static void remove(String prefix) {
        cache.remove(prefix);
        System.gc();
    }

    public static void remove(String prefix, String name) {
        if (!cache.containsKey(prefix)) {
            return;
        }
        if (!Cache.get(prefix).containsKey(name)) {
            return;
        }
        Cache.get(prefix).remove(name);
        System.gc();
    }

    public static Object get(String prefix, String name) {
        if (!Cache.get(prefix).containsKey(name)) {
            throw new RuntimeException("Name " + name + " not found in cache.");
        }
        return Cache.get(prefix).get(name);
    }

    public static Hashtable get(String prefix) {
        if (!cache.containsKey(prefix)) {
            throw new RuntimeException("Prefix " + prefix + " not found in cache.");
        }
        return (Hashtable)cache.get(prefix);
    }

    public static void printList() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = cache.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            sb.append("Prefix: [");
            sb.append(key);
            sb.append("] -> ");
            Hashtable h2 = (Hashtable)cache.get(key);
            Enumeration e2 = h2.keys();
            while (e2.hasMoreElements()) {
                Object key2 = e2.nextElement();
                sb.append("name: [");
                sb.append(key2);
                sb.append("] value: [");
                if (h2.get(key2) instanceof Image) {
                    sb.append("image");
                } else {
                    sb.append(h2.get(key2));
                }
                sb.append("] ");
            }
            sb.append("\n");
        }
        System.err.print(sb.toString());
    }

    public static boolean contains(String prefix, String name) {
        return cache.containsKey(prefix) && Cache.get(prefix).containsKey(name);
    }

    public static boolean contains(String prefix) {
        return cache.containsKey(prefix);
    }
}

