////////////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////
/// NOTE: This file is automatically generated from the J2ME java sources!
///

package StarifficEditorGame;

import javax.microedition.lcdui.*;

public abstract class MenuScreen extends MenuBackgroundScreen
{
    private String[] m_items;
    
    private int m_selected;
    private Screen m_next;
    
    public MenuScreen()
    {
        m_items = getItems();
    }
    
    /**
     * Updates the screen for a fixed amount of time.
     * 
     * @param fp_secs The time to update, in fixed point seconds.
     */
    public Screen updateFrame( int fp_secs )
    {
        if (m_next != null)
            return m_next;
        return null;
    }
    
    /**
     * Renders the current state to the given graphics.
     * 
     * @param g The destination graphics.
     * @param w The screen width.
     * @param h The screen height.
     */
    public void render( Graphics g, int w, int h )
    {
        super.render( g, w, h );
        
        g.setFont( Font.getFont( Font.FACE_MONOSPACE, Font.STYLE_BOLD, Font.SIZE_MEDIUM ) );
        int text_h = g.getFont().getHeight();
        
        int y = h / 4;
        for ( int i = 0; i < m_items.length; ++i )
        {
            if ( i == m_selected )
                g.setColor( 0xffffffff );
            else
                g.setColor( 0xff888888 );
            
            MiscUtils.writeCentered( g, m_items[i], y, w );
            
            y += text_h * 2;
        }
    }

    public void keyPressed( int key, int game_key )
    {
        if (game_key == Canvas.FIRE)
        {
            m_next = selectItem( m_selected );
            return;
        }
        
        if (game_key == Canvas.UP)
        {
            m_selected--;
            if (m_selected < 0)
                m_selected = m_items.length - 1;
        }
        
        if (game_key == Canvas.DOWN)
        {
            m_selected++;
            if (m_selected >= m_items.length)
                m_selected = 0;
        }
    }
    
    protected abstract String[] getItems();
    protected abstract Screen selectItem( int idx );
}
