using System;
using System.Collections.Generic;
using System.IO;
using System.Text;

namespace StarifficEditor
{
    public class Meshes
    {
        private String m_path;

        public Mesh[] MeshList
        {
            get
            {
                Mesh[] ret = (new List<Mesh>( meshes.Values )).ToArray();
                Array.Sort(ret, delegate(Mesh m1, Mesh m2) { return String.Compare(m1.name, m2.name); });
                return ret;
            }
        }

        public Dictionary<String, Mesh> meshes;

        public static Meshes global_meshes = new Meshes("");

        public Meshes(String path)
        {
            m_path = path;
            meshes = new Dictionary<string, Mesh>();
            Refresh();
        }

        public void Refresh()
        {
            meshes.Clear();

            if (m_path == "")
                return;

            try
            {
                foreach (String fname in Directory.GetFiles(m_path, "*.obj"))
                {
                    try
                    {
                        Mesh mesh = new Mesh(fname);
                        meshes[mesh.name] = mesh;
                    }
                    catch (Exception e)
                    {
                        Console.WriteLine("Error reading mesh '" + fname + "': " + e);
                    }
                }
            }
            catch (Exception)
            {
            }
        }

        public byte[] Export()
        {
            using (MemoryStream dest_stm = new MemoryStream())
            {
                JavaBinaryWriter dest_out = new JavaBinaryWriter(dest_stm);
                dest_out.FixedNumberScale = 1.0f / 10.0f;

                // Get the meshes sorted in id order
                Mesh[] msh_lst = MeshList;
                Array.Sort(msh_lst, delegate(Mesh m1, Mesh m2) { int id1 = m1.Id; int id2 = m2.Id; return (id1<id2) ? -1 : ((id1>id2) ? 1 : 0); });

                // Write the meshes
                dest_out.Write((short)msh_lst.Length);
                foreach (Mesh m in msh_lst)
                {
                    m.Export(dest_out);
                }

                // Get the data
                dest_out.Flush();
                return dest_stm.ToArray();
            }
        }

        public bool Export(String filename)
        {
            // Generate the data
            byte[] data = Export();

            // Write the file
            try
            {
                using (FileStream fout = new FileStream(filename, FileMode.Create, FileAccess.Write))
                {
                    fout.Write(data, 0, data.Length);
                }
            }
            catch (Exception)
            {
                return false;
            }

            return true;
        }
    }
}
