varying vec3 normal;
//varying vec4 color;

#vertexshader

const int NUMBONES = 60;
uniform mat4 Bones[NUMBONES];

attribute vec4 Vertex;

varying vec3 NormalOut;
varying vec4 ColorOut;
void main()
{
	vec4 Pos0 = vec4(Vertex.xyz, 1.0);
	int index = int(Vertex.w);

	mat4 Bone = Bones[index];
	vec4 Pos = Bone * Pos0;

	gl_Position = gl_ModelViewProjectionMatrix * Pos;
	Bone[3][0] = 0.0;
	Bone[3][1] = 0.0;
	Bone[3][2] = 0.0;
	NormalOut = normalize((Bone * vec4(gl_Normal,1)).xyz);
	
	ColorOut = gl_Color;
	gl_TexCoord[0] = gl_MultiTexCoord0;
	gl_TexCoord[1] = gl_MultiTexCoord1;
}

#fragmentshader

varying vec3 NormalOut;
varying vec4 ColorOut;

void main()
{
	vec3 lightdir = normalize(vec3(1.0,1.0,0.0));
	vec3 c = (dot(lightdir, NormalOut)+0.5)/1.5 * ColorOut.xyz;
	gl_FragColor = vec4(c*2,1);
}
