float4x4 view_proj_matrix: register(c0);
float4x4 view_matrix: register(c4);
float noiseRate: register(c8);
struct VS_OUTPUT {
   float4 Pos:      POSITION;
   float3 normal:   TEXCOORD0;
   float3 tangent:  TEXCOORD1;
   float3 binormal: TEXCOORD2;
   float3 viewVec:  TEXCOORD3;
   float3 pos:      TEXCOORD4;
};

VS_OUTPUT vp_main(float4 Pos: POSITION, float3 tangent: TANGENT, float3 binormal: BINORMAL, float3 normal: NORMAL){
   VS_OUTPUT Out;

   Out.Pos = mul(view_proj_matrix, Pos);
   // Transform our tangent-space into eye-space
   Out.normal   =  mul(view_matrix, normal);
   Out.binormal =  mul(view_matrix, binormal);
   Out.tangent  =  mul(view_matrix, tangent);
   // The view-vector in eye-space is -eyePos
   Out.viewVec  = -mul(view_matrix, Pos);
   // Texture coords for the noise
   Out.pos = Pos.xyz * noiseRate;

   return Out;
}



