float4x4 view_proj_matrix: register(c0);
float4 view_position: register(c4);

struct VS_OUTPUT {
   float4 Pos:     POSITION;
   float3 normal:  TEXCOORD0;
   float3 viewVec: TEXCOORD1;
};

VS_OUTPUT vp_main(float4 Pos: POSITION, float3 normal: NORMAL)
{
   VS_OUTPUT Out;

   Out.Pos = mul(view_proj_matrix, Pos);
   Out.normal = normal;
   Out.viewVec = view_position - Pos;

   return Out;
}
