#pragma once

#include <string.h>
#include "Vector.h"
#include "Quaternion.h"

class CVector3f;
class CVector4f;
class CQuaternion;

class CMatrix4x4f
{
	
public:

	float m_Data[16];
	
	// Constructors and stuff
	CMatrix4x4f();
	CMatrix4x4f(float* data) {
		for(int i = 0; i < 16; i++)
			m_Data[i] = data[i];
	}
	CMatrix4x4f(const CQuaternion& arg);
	// Copy constructor and = operator
	CMatrix4x4f(const CMatrix4x4f& arg) {
		for(int i = 0; i < 16; i++)
			m_Data[i] = arg.m_Data[i];
	}
	CMatrix4x4f operator = (const CMatrix4x4f& arg) {
		for(int i = 0; i < 16; i++)
		{
			m_Data[i] = arg.m_Data[i];
		}
			return *this; 
	}
	
	bool operator == (const CMatrix4x4f& arg){
		for(int i = 0; i < 16; i++){
			if(!(m_Data[i] == arg.m_Data[i]))
				return false;
		}
		return true;
	}
	
	void identity(){(*this)=CMatrix4x4f();}
	
	void changeInternal(){
		float newData[16];
		newData[0]=m_Data[0];
		newData[1]=m_Data[4];
		newData[2]=m_Data[8];
		newData[3]=m_Data[12];
		newData[4]=m_Data[1];
		newData[5]=m_Data[5];
		newData[6]=m_Data[9];
		newData[7]=m_Data[13];
		newData[8]=m_Data[2];
		newData[9]=m_Data[6];
		newData[10]=m_Data[10];
		newData[11]=m_Data[14];
		newData[12]=m_Data[3];
		newData[13]=m_Data[7];
		newData[14]=m_Data[11];
		newData[15]=m_Data[15];
		memcpy((void*)m_Data,(void*)newData,16*sizeof(float));
	}
	
	// Accessing matrix elements
	// 1. matrix[column][row]
	float* operator[](int i) {
		return &(m_Data[i*4]);
	}
	const float* operator[](int i) const {
		return &(m_Data[i*4]);
	}
	// 2. matrix[element]
	// [ 0  4   8   12 ]
	// [ 1  5   9   13 ]
	// [ 2  6   10  14 ]
	// [ 3  7   11  15 ]
	
	// Various matrix operations
	CMatrix4x4f operator*(const CMatrix4x4f& arg) const;
	CMatrix4x4f operator*=(const CMatrix4x4f& arg) {
		return (*this)=(*this)*arg;
	}
	
	CVector3f operator*(const CVector3f& arg) const;
	CVector4f operator*(const CVector4f& arg) const;
	
	void rotate(float x, float y, float z);
	void translate(float x, float y, float z);
	void scale(float x, float y, float z);
	
};