#pragma once

#include <vector>
#include <string>
#include "Vector.h"
#include "SDL.h"

using std::vector;
using std::string;

struct tFace{
	vector<int> vertex;
	vector<int> normal;
	vector<int> texcoord;
};

struct tObject{
	int callist;
	int callistWire;
	vector<tFace> faces;
	string name;
	
	tObject() : callist(-1),callistWire(-1) {}
	tObject(const tObject& arg){
		callist = arg.callist;
		callistWire = arg.callistWire;
		faces = arg.faces;
		name = arg.name;
	}
	tObject& operator=(const tObject& arg){
		callist = arg.callist;
		faces = arg.faces;
		name = arg.name;
		return (*this);
	}
};

struct tBone{
	int parent;
	CQuaternion rot;
	CVector3f pos;
	
	CMatrix4x4f transf;
	bool calculated;
	float radius;
	
	tBone() : calculated(false), radius(0.25f), rot(CQuaternion()) {}
	tBone(const tBone& arg) : parent(arg.parent), rot(arg.rot)
		, pos(arg.pos), radius(arg.radius) {calculated = false;}
	tBone& operator=(const tBone& arg){
		parent = arg.parent;
		rot = arg.rot;
		pos = arg.pos;
		radius = arg.radius;
		calculated = false;
		
		return (*this);
	}
};

struct tBoneRef
{
	vector<int> bone;
	vector<float> blend;
};

struct tKeyframe
{
	float time;
	vector<tBone> bone;
};

class CObjLoader
{
private:
	vector<tObject> m_Object;
	vector<CVector3f> m_Vertex;
	vector<CVector3f> m_Normal;
	vector<CVector2f> m_Texcoord;
	vector<tBoneRef> m_BoneRef;
	
	vector<tBone> m_Bones;
	vector<tKeyframe> m_Keyframes;
	float time;
	unsigned int last;
public:
	void loadObjects(string file);
	
	CObjLoader(){last=SDL_GetTicks();}
	CObjLoader(string file){loadObjects(file);}
	
	vector<tObject> getObjects(){return m_Object;}
	vector<CVector3f> getVertices(){return m_Vertex;}
	vector<CVector3f> getNormals(){return m_Normal;}
	vector<CVector2f> getTexcoords(){return m_Texcoord;}
	
	void clear(){m_Object.clear();m_Vertex.clear();m_Normal.clear();m_Texcoord.clear();}
	
	void draw();
	void drawOutline();
	
	void createBoneTransformationMatrix(int bone, tKeyframe& keyframe);
};