#pragma once

#include <string>
#include <vector>
#include <map>
#include <stdio.h>

#include <OpenGL/gl.h>

#include "Vector.h"
#include "Matrix.h"
#include <stdio.h>

using std::string;
using std::map;
using std::pair;
using std::vector;

class CGLSLShader
{
protected:
	GLuint vShader;
	GLuint fShader;
	GLuint mProgram;
public:
	CGLSLShader(string vertex, string fragment);
	CGLSLShader(){}
	void init(string vertex, string fragment);
	~CGLSLShader();
	void use();
	void stop();
};

class CGLSLPhong : public CGLSLShader
{
private:
	GLint Feye;
	float mFeye[3];
public:
	CGLSLPhong(){
		init("EV3D.app/Contents/Resources/phong.vert", "EV3D.app/Contents/Resources/phong.frag");
		Feye = glGetUniformLocation(mProgram, "Feye");
	}
	void setEye(const CVector3f& arg){mFeye[0]=arg.x;mFeye[1]=arg.y;mFeye[2]=arg.z;
		glUniform3fv(Feye, 3, mFeye);
	}
};

class CGLSLHorseBody : public CGLSLShader
{
private:
	GLint Feye;
	float mFeye[3];
	
	GLint Ftransform1;
	float mFtransform1[16];
	GLint Ftransform1percent;
	float mFtransform1percent;
	
	GLint Ftransform2;
	float mFtransform2[16];
	GLint Ftransform2percent;
	float mFtransform2percent;
	
	GLint Fposition;
	float mFposition[16];
public:
	CGLSLHorseBody(){
		init("horse.app/Contents/Resources/horse_body.vert", "horse.app/Contents/Resources/horse_body.frag");
		Feye = glGetUniformLocation(mProgram, "Feye");
		Ftransform1 = glGetAttribLocation(mProgram, "transform1");
		Ftransform2 = glGetAttribLocation(mProgram, "transform2");
		Ftransform1percent = glGetAttribLocation(mProgram, "transform1percent");
		Ftransform2percent = glGetAttribLocation(mProgram, "transform2percent");
		Fposition = glGetAttribLocation(mProgram, "posi");
	}
	void setEye(const CVector3f& arg){mFeye[0]=arg.x;mFeye[1]=arg.y;mFeye[2]=arg.z;
		glUniform3fv(Feye, 3, mFeye);
	}
	void setTransform1(const CMatrix4x4f& arg){
		for(int i = 0; i < 16; i++)
			mFtransform1[i] = arg.m_Data[i];
		for(int i = 0; i < 4; i++)
			glVertexAttrib4fv(Ftransform1+i, mFtransform1+4*i);
	}
	void setTransform1percent(float arg){mFtransform1percent=arg;
			glVertexAttrib1f(Ftransform1percent, mFtransform1percent);
	}
	void setTransform2(const CMatrix4x4f& arg){
		for(int i = 0; i < 16; i++)
			mFtransform2[i] = arg.m_Data[i];
		for(int i = 0; i < 4; i++)
			glVertexAttrib4fv(Ftransform2+i, mFtransform2+4*i);
	}
	void setTransform2percent(float arg){mFtransform2percent=arg;
		glVertexAttrib1f(Ftransform2percent, mFtransform2percent);
	}
	void setPosition(const CVector3f& arg){mFposition[0]=arg.x;mFposition[1]=arg.y;mFposition[2]=arg.z;mFposition[3]=0.0f;
		glVertexAttrib4fv(Fposition, mFposition);
	}
};