shared float4x4 World          : WORLD          < string SasBindAddress = "Sas.Skeleton.MeshToJointToWorld[0]"; >;
shared float4x4 View           : VIEW           < string SasBindAddress = "Sas.Camera.WorldToView"; >;
shared float4x4 Projection     : PROJECTION     < string SasBindAddress = "Sas.Camera.Projection"; >;
shared float3   CameraPosition : CAMERAPOSITION < string SasBindAddress = "Sas.Camera.Position"; >;
shared float4   Time           : TIME           < string SasBindAddress = "Sas.Time.Now"; >;
shared float3   LightDir       : DIRECTION      < string SasBindAddress = "Sas.DirectionalLight[0].Direction"; >;

float V_Time : TIME;
float V_A = 1.1;
float V_B = 30.0;
float V_C = 0.8;
float V_D = 70.0;
float V_E = 1.2;
float V_F = 55.0;
float V_T = 0.0;

//===========================================================================
void VertexShader0(float3 position : POSITION, float2 texin : TEXCOORD0, out float4 oPos : POSITION, out float2 oT0 : TEXCOORD0)
{
  float3 pos = position;
  pos.x = pos.x + sin((V_Time+V_T) * V_A) * V_B;
  pos.y = pos.y + sin((V_Time+V_T) * V_C) * V_D;
  pos.z = pos.z + sin((V_Time+V_T) * V_E) * V_F;
  oPos  = mul(mul(mul(float4(pos, 1), World), View), Projection);
  oT0   = texin;
}

struct VS_OUTPUT
{
  float2 Tex0: TEXCOORD0;
};

sampler2D Tex = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

//===========================================================================
float4 PixelShader0(VS_OUTPUT In) : COLOR0
{
  return tex2D(Tex, In.Tex0);
}

technique T0
{
  pass P0
  {
    VertexShader = compile vs_1_1 VertexShader0();
    PixelShader  = compile ps_1_1 PixelShader0();
  }
}
