;******************************************************************************
; tunnel.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
%assign CIRCLE_SH 5
%assign CIRCLE_RES (1 << CIRCLE_SH)
%assign RING_RES 32
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
gtunnel: dd PACKB2DW(CURVE_FLAG_LOOP,1,CURVE_PQTORUS,128),3.0,4.0,100.0
tunnelRadius: dd 10.0
ringRadius: dd 2.0
ringDeform: dd 0.2
trailRadius: dd 1.0
scaleMin: dd 3.0
scaleAmpl: dd 2.0
tunScale: dd 1.0,1.0,1.0
camFOVmin: dd 0.8726646259971
;camFOVampl: dd 0.6108652381980
duScale: dd 2.0
dvScale: dd 40.0
;==============================================================================
section .bss
;==============================================================================
gring: resb trail_size
tunnelCam: resb camera_size
vCounter: resd 1
tunnelPos: resd 1
tunnelDist: resd 1
tunnelUVfix: resd 2
ringVec: resb vec3_size *40
duLUT: resd CIRCLE_RES
dvLUT: resd 256
;==============================================================================
section .text
;==============================================================================
SDECL _initLUT, 0
;==============================================================================
    LCTX    esp
    LVAR    4, den
    mov     dword[%$den],CIRCLE_RES
    fld     dword[duScale]
;    mov     eax,dword[myobject]
;    fst     dword[eax +vertex.u0]
    fst     dword[tunnelUVfix]
    fidiv   dword[%$den]
    lea     edx,[duLUT]
    fldz
.iterDU:
    fst     dword[edx]
    fadd    st1
;next
    add     edx,4
    dec     dword[%$den]
    jnz     .iterDU
    _EMMS

    fld1
    fstp    dword[tunnelDist]
    RasSetVtxBuf [myobject], CIRCLE_RES
    mov     dword[V3_renderFn], _initDvLUT
    M33id OBJ_tform +objtform.rm
    V3setNull OBJ_tform +objtform.rm +matrix.t
    ObjSetScale tunScale
    ObjSetFlags 0, 0, 0
    CCALL   _CURVE_render3D, gtunnel, 256
    CCALL   _CURVE_render3D, gtunnel, 256
DECLEND
;==============================================================================
SDECL _initDvLUT, 0
;==============================================================================
    LCTX    esp
    LARG    4, _pvec, _count
    
;    fldpi
;    fadd    st0
;    fmul    dword[tunnelRadius]
    fld     dword[dvScale]
    fdiv    dword[tunnelDist]
    mov     edx,dword[%$_pvec]
    mov     eax,dvLUT
    fldz
.iterV:
    fld     st0
    fmul    st2
    fstp    dword[eax]
    fld     dword[edx +vec3_size +vec3.x]
    fsub    dword[edx +vec3.x]
    fmul    st0
    fld     dword[edx +vec3_size +vec3.y]
    fsub    dword[edx +vec3.y]
    fmul    st0
    fld     dword[edx +vec3_size +vec3.z]
    fsub    dword[edx +vec3.z]
    fmul    st0
    faddp   st1
    faddp   st1
    fsqrt
    faddp   st1
    
;next
    add     edx,vec3_size
    add     eax,4
    dec     dword[%$_count]
    jnz     .iterV
    fst     dword[tunnelDist]
    fmulp   st1
;    mov     eax,dword[myobject]
;    fstp    dword[eax +vertex.v0]
    fstp    dword[tunnelUVfix +4]
.exit:
    _EMMS
DECLEND
;==============================================================================
SDECL _initTunnel, 0
;==============================================================================
    CCALL   _CIRCLE_make, [myobject], CIRCLE_RES, [tunnelRadius]
    
    CameraInit tunnelCam, [myscene +scene.fb +tex.w],[myscene +scene.fb +tex.h]
    CCALL   _setCamFOV, tunnelCam, [camFOVmin]
    CCALL   _initLUT
    
    CCALL   _TRAIL_init, gring, 64, 10
    mov     dword[gring +trail.tex],gtexFlare1d
    rgbaUnpack gring +trail.c, PACKB2DW(0,240,128,128)
DECLEND
;==============================================================================
SDECL _updateTunnel, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LVAR    vec3_size, newpos
    LVAR    4, delta, fovAngle
    LENTER
    
;    fld     dword[RTM_time]
;    mov     dword[%$delta],250
;    fidiv   dword[%$delta]
;    fld     dword[beatTimer +timer.sec]
;    mov     dword[%$delta],150
;    fidiv   dword[%$delta]
;    faddp   st1
    fld     dword[RTM_time]
    mov     dword[%$delta],50
    fidiv   dword[%$delta]

    fld     st0
    frndint
    fsubp   st1
    fstp    dword[tunnelPos]
    IsSysFlagSet(SYSFLAG_UPDATE)
    jz      .endFollow
    lea     eax,[%$newpos]
    CCALL   _getTorusPos, eax, gtunnel, [tunnelPos]
    lea     eax,[%$newpos]
    CameraFollow tunnelCam, eax
.endFollow:

    CCALL   _FN_sin, [RTM_time], 0, REAL_PI, REAL_2PI, 40, 0
    mov     dword[%$delta],5
;    fmul    dword[beatTimer +timer.dt]
    fmul    dword[RTM_dt]
    fidiv   dword[%$delta]
    lea     eax,[tunnelCam +camera.irm +matrix.n]
    fstp    dword[%$delta]
    CameraRotateAA tunnelCam, eax, [%$delta]
    CameraUpdate tunnelCam

;    CCALL   _FN_sin, [RTM_time], [camFOVmin], [camFOVampl], REAL_2PI, 15, 0
;    fstp    dword[%$fovAngle]
;    mov     eax,dword[%$fovAngle]
;    CCALL   _setCamFOV, tunnelCam, [camFOVmin]
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _getTorusPos
;==============================================================================
	LCTX	esp
	LARG	4, _pV3, _pCurveInfo, _ratio
	mov     eax,dword[%$_pCurveInfo]
	mov     edx,dword[%$_pV3]
;find delta
	fldpi
	fadd    st0
	fmul    dword[%$_ratio]
	fld     dword[eax +curve2d.data +pqtorus.p]
	fmul    st1
	fld     dword[eax +curve2d.data +pqtorus.q]
	fmulp   st2         ;p q

    fsincos             ;cp sp q
    fxch    st2
    fsincos             ;cq sq sp cp
    fxch    st1         ;sq cq sp cp
    fmul    dword[Real1d2]
    fadd    dword[eax +curve2d.data +pqtorus.rad]
    fmul to st1
    fmul to st2
    fmulp   st3
    fstp    dword[edx +vec3.y]
    fstp    dword[edx +vec3.z]
    fstp    dword[edx +vec3.x]
.exit:
DECLEND
;==============================================================================
SDECL _VPGM_tunnel
;==============================================================================
    LCTX    esp
    LARG    4, _vert
    
    mov     edx,dword[%$_vert]
    mov     eax,dword[vCounter]
    and     eax,CIRCLE_RES -1
    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMax]
    fmul    dword[duLUT +eax*4]
    mov     eax,dword[vCounter]
    shr     eax,CIRCLE_SH
;    fld     dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +4]
    fld     dword[dvLUT +eax*4]
    fstp    dword[edx +vertex.v0]
    fstp    dword[edx +vertex.u0]
    inc     dword[vCounter]
.exit:
DECLEND
;==============================================================================
SDECL _VPGM2_tunnel
;==============================================================================
    LCTX    esp
    LARG    4, _dst, _v1, _v2, _v3, _dummy
    
    _EMMS
    SETVDECL VDECL_T0
    mov     edi,dword[%$_dst]
    
    mov     eax,dword[%$_v1]
    fld     dword[eax +vertex.v0]
    frndint
    mov     eax,dword[%$_v3]
    fld     dword[eax +vertex.v0]
    frndint
    _FCOM   st1
    jnc     .endMin
    fxch    st1
.endMin:
    ffreep  st0
    
    mov     edx,-3
.iter3x:
    mov     esi,dword[%$_dummy +edx*4]
    mov     eax,dword[esi +vertex.x]
    mov     dword[edi +vertexUP.x],eax
    mov     eax,dword[esi +vertex.y]
    mov     dword[edi +vertexUP.y],eax
    mov     eax,dword[esi +vertex.z]
    mov     dword[edi +vertexUP.z],eax
;clear unused
    xor     eax,eax
    mov     dword[edi +vertexUP.dum1],eax
    mov     dword[edi +vertexUP.dum2],eax
    mov     dword[edi +vertexUP.dum3],eax

    mov     eax,dword[esi +vertex.u0]
    mov     dword[edi +vertexUP.u0],eax
    fld     dword[esi +vertex.v0]
    fsub    st1
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +4]
    fstp    dword[edi +vertexUP.v0]
    
    add     edi,vertexUP_size
    inc     edx
    jnz     .iter3x
    ffreep  st0
.exit:
DECLEND
;==============================================================================
SDECL _renderTunnel, 0
;==============================================================================
    TexClear    myscene +scene.fb
;    TexClear    myscene +scene.zb
    RasSetCam   tunnelCam

    RasSetCulling CULLING_FRONT
    RasSetFpgm _FPGM_T0biAdd
    RasSetVpgm _VPGM2_tunnel
    RasSetTex   0, gtexBubbles
    CCALL   _CIRCLE_make, [myobject], CIRCLE_RES, [tunnelRadius]
    RasSetVtxBuf [myobject], CIRCLE_RES
    mov     dword[V3_renderFn], _CURVE_tess
    xor     eax,eax
    mov     dword[vCounter],eax
    mov     eax,dword[myobject]
    fld     dword[tunnelUVfix]
    fstp    dword[eax +vertex.u0]
    fld     dword[tunnelUVfix +4]
    fstp    dword[eax +vertex.v0]
    
    M33id OBJ_tform +objtform.rm
    V3setNull OBJ_tform +objtform.rm +matrix.t
    ObjSetScale tunScale
    ObjSetFlags 0, 0, OBJF_FIXUV
    ObjSetVpgm _VPGM_tunnel

    CCALL   _CURVE_render3D, gtunnel, 256
;render rings
    CCALL   _CIRCLE_make, [myobject], RING_RES, [ringRadius]
    RasSetVtxBuf [myobject], RING_RES
    mov     dword[V3_renderFn], _renderRings
    ObjSetFlags 0, 0, 0
    CCALL   _CURVE_render3D, gtunnel, 256
.exit:
DECLEND
;==============================================================================
SDECL _renderRings, 0
;==============================================================================
    MPUSH   esi,edi,ebp
    LCTX    ebp
    LARG    4, _pvec, _count
    LVAR    4, pos, icount
    LENTER
    
    fld     dword[tunnelPos]
    fimul   dword[%$_count]
    fistp   dword[%$pos]
    mov     edi,ringVec
    mov     dword[%$icount],16
    mov     edx,dword[%$pos]
.iterV:
    imul    esi,edx,vec3_size
    add     esi,dword[%$_pvec]
    V3eq    edi, esi
;next
    inc     edx
    cmp     edx,dword[%$_count]
    jl      .endwrap
    xor     edx,edx
.endwrap:
    add     edi,vec3_size
    dec     dword[%$icount]
    jnz     .iterV
.render:
	RasSetFpgm _FPGM_RGBxT0add
    CCALL   _CURVE_renderRings, ringVec +vec3_size,14,gring,[trailRadius],REAL_PID4
;    CCALL   _CURVE_renderRings, [%$_pvec],[%$_count],gring,[trailRadius],REAL_PID4
.exit:
    LEXIT
    MPOP    esi,edi,ebp
DECLEND
;==============================================================================
