;******************************************************************************
; wavy.asm
; 2006/11/05
; Martin Veilleux
;******************************************************************************
;==============================================================================
; INCLUDES
;==============================================================================
;==============================================================================
; DEFINITIONS
;==============================================================================
;==============================================================================
; MACROS
;==============================================================================
;==============================================================================
section .data
;==============================================================================
wavyScale: dd 1.0,1.0,1.0
wavyFreqMin: dd 2.5
wavyFreqAmpl: dd -0.5
wavyAmpl: dd -0.2
wavyAngSpeed: dd -56.0
wavyCamPolarMin: dd 0.6
wavyCamPolarAmpl: dd 0.2
wavyCamDistMin: dd -0.9
;wavyCamDistMax: dd 0.3
;wavyCamBeatDist: dd 0.1
wavyBeatDamp: dd 0.2
greal256dpi: dd 81.487330863
wavyRadOffsetMin: dd 64.0
wavyRGBmin: dd 192.0
wavyPhoton: dd 0,0,gtexRainbow,PSF_RESPAWN | PSF_ZTEST,0.5,1.5,0.1,0.8,0.2,0.04,0.5,0xffcdfe
dd 0,0,0, 0,0,0,1.0, 256.0,256.0,256.0,0
wavyRevEvent: dd REAL_1M, 2.142857,0.428571, _reversePicture, 0,EVENTF_FADEIO
;==============================================================================
section .bss
;==============================================================================
wavyCamera: resb camera_size
wavyOffset: resd 1
wavyRadOffset: resd 1
wavyFreq: resd 1
wavyTimeDir: resd 1
wavyAngLUT: resd 256

;==============================================================================
section .text
;==============================================================================
SDECL _initWavyLUT, 0
;==============================================================================
    LCTX    esp
    LVAR    4, den
    
    mov     dword[%$den],256
    fldpi
    fadd    st0
    fidiv   dword[%$den]
    xor     edx,edx
    mov     dword[wavyAngLUT],edx
    inc     edx
    fld     st0
.iterN:
    fld     st0
    fcos
    fchs
    fmul    dword[Real1d2]
    fadd    dword[Real1d2]
    fstp    dword[wavyAngLUT +edx*4]
.next:
    fadd    st1
    inc     dl
    jnz     .iterN
.exit:
    _EMMS
DECLEND
;==============================================================================
SDECL _initWavy, 0
;==============================================================================
    CameraInit wavyCamera, [myscene +scene.fb +tex.w],[myscene +scene.fb +tex.h]
    CCALL   _initWavyLUT
    CCALL   _PS_init, wavyPhoton, 256
    CCALL   _PS_resetPhoton, wavyPhoton
    QuatFromPolar wavyPhoton +photonPS.qr, REAL_PI, 0
    xor     eax,eax
    mov     dword[wavyTimeDir],eax
DECLEND
;==============================================================================
SDECL _getBeatDir, 0
;==============================================================================
    fld1
    mov     eax,dword[defaultBeat +beatinfo.count]
    and     eax,7
    cmp     eax,3
    jle     .exit
    fchs
.exit:
DECLEND
;==============================================================================
SDECL _updateWavy, 0
;==============================================================================
    MPUSH   ebp
    LCTX    ebp
    LVAR    4, aY, aX, pqr, beatdir
    LVAR    vec4_size, qr,qf
    LENTER
    
    CCALL   _FN_sin, [RTM_time], 0, REAL_2PI, [greal2000pi], 67450, 1
    fstp    dword[%$aY]
    CCALL   _FN_sin, [RTM_time], [wavyCamPolarMin], [wavyCamPolarAmpl], [greal2000pi], 5000, 1
    fstp    dword[%$aX]
    lea     eax,[%$qr]
    mov     dword[%$pqr],eax
    QuatFromPolar [%$pqr],[%$aX],[%$aY]
;    QuatFromPolar [%$pqr],[wavyCamPolarMin],[%$aY]
    Quat2m33 RTmatrix, [%$pqr]
    CCALL   _FN_sin, [RTM_time], REAL_PI, REAL_PID6, [greal2000pi],14768, 0
    fstp    dword[%$aX]
    lea     eax,[%$qf]
    QuatFromAA eax,RTmatrix +matrix.n,[%$aX]
    lea     eax,[%$qf]
    QuatMul [%$pqr],eax,[%$pqr]
    QuatNorm [%$pqr]
    Quat2m33 RTmatrix, [%$pqr]
    
;    CCALL   _FN_sin, [RTM_time], [wavyCamDistMin], [wavyCamDistMax], [greal2000pi], 17000, 1
;    fld     dword[wavyCamBeatDist]
;    fmul    dword[beatAmp]
;    faddp   st1
;    fstp    dword[%$aX]
;    V3smul  %$qr, RTmatrix +matrix.n, %$aX
    V3smul  %$qr, RTmatrix +matrix.n, wavyCamDistMin
    lea     eax,[%$qr]
    CameraSetPos wavyCamera, eax
    M33transpose OBJ_tform +objtform.rm, RTmatrix
    CameraSetRot wavyCamera, OBJ_tform +objtform.rm
    CameraUpdate wavyCamera
    
    fld     dword[beatTimer +timer.sec]
    fmul    dword[wavyAngSpeed]
    fstp    dword[wavyOffset]
    CCALL   _FN_sin, [RTM_time], [wavyFreqMin], [wavyFreqAmpl], [greal2000pi], 4000, 1
    fstp    dword[wavyFreq]
    CCALL   _FN_sin, [RTM_time], [wavyRadOffsetMin], [wavyRadOffsetMin], [greal2000pi], 2666, 1
    fistp   dword[wavyRadOffset]
    CCALL   _FN_sin, [RTM_time], [wavyRGBmin], [wavyRadOffsetMin], [greal2000pi],  8000, 1
    fstp    dword[wavyPhoton +photonPS.c +rgbaUP.b]
    CCALL   _FN_sin, [RTM_time], [wavyRGBmin], [wavyRadOffsetMin], [greal2000pi],  6261, 1
    fstp    dword[wavyPhoton +photonPS.c +rgbaUP.r]
    CCALL   _FN_sin, [RTM_time], [wavyRGBmin], [wavyRadOffsetMin], [greal2000pi],  4777, 1
    fstp    dword[wavyPhoton +photonPS.c +rgbaUP.g]
    
    CCALL   _getBeatDir
    fstp    dword[%$beatdir]

    cmp     dword[wavyTimeDir],0
    jne     .isBackward
    test    dword[%$beatdir],REAL_SIGNMASK
    jz      .endBackTest
    mov     dword[wavyTimeDir],1
;start time event
    fld     dword[RTM_time]
    fstp    dword[wavyRevEvent +timeevent.mark]
    jmp     .endBackTest
.isBackward:
    test    dword[%$beatdir],REAL_SIGNMASK
    jnz     .endBackTest
    xor     eax,eax
    mov     dword[wavyTimeDir],eax
.endBackTest:
.exit:
    LEXIT
    MPOP    ebp
DECLEND
;==============================================================================
SDECL _VPGM_wavyCyl
;==============================================================================
    MPUSH   edi
    LCTX    esp
    LARG    4, _pvert, _rad, _angle
    LVAR    64,dummy
    LVAR    4, ampl, damp, angdamp, nx, ny
;set color
    mov     edi,dword[%$_pvert]

;    M33mulV3 RTmatrix, RAS_main +raster.cam +camera.irm, edi
;    fld     dword[RTmatrix +vec3.x]
;    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +xtexinfo_size]
;    fld     dword[RTmatrix +vec3.y]
;    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +4 +xtexinfo_size]
;    fxch    st1
;    fstp    dword[edi +vertex.u1]
;    fstp    dword[edi +vertex.v1]
;set pos
    fld     dword[%$_rad]
    fmul    dword[greal256]
    fld     st0
    fmul    dword[wavyFreq]
    fadd    dword[wavyOffset]
    fld     dword[%$_angle]
    fmul    dword[greal256dpi]
    fxch    st2
    fistp   dword[%$damp]
    fistp   dword[%$ampl]
    fistp   dword[%$angdamp]
    
    mov     eax,dword[%$damp]
    and     eax,0xff
    fld     dword[wavyAngLUT +eax*4]
    mov     dword[%$dummy],4
    fimul   dword[%$dummy]
    _FCOM_MEM dword[Real1]
    jc      .endClip
    ffreep  st0
    fld1
.endClip:
    movzx   eax,byte[%$ampl]
    fld     dword[wavyAngLUT +eax*4]
    fmul    st0
    fmul    st1     ;y damp
    movzx   eax,byte[%$angdamp]
    fmul    dword[wavyAngLUT +eax*4]
    fxch    st1
    movzx   eax,byte[%$ampl]
    add     al,byte[wavyRadOffset]
    fld     dword[wavyAngLUT +eax*4]
    fmul    st0
    fmulp   st1
    movzx   eax,byte[%$angdamp]
    add     al,128
    fmul    dword[wavyAngLUT +eax*4]
    faddp   st1
    fst     dword[%$damp]
    fmul    dword[wavyAmpl]
    fstp    dword[edi +vertex.z]
;set tex coord
    movzx   eax,byte[%$angdamp]
    fld     dword[wavyAngLUT +eax*4]
    fsub    dword[Real1d2]
    fmul    dword[%$damp]
    fadd    dword[edi +vertex.x]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax]

    movzx   eax,byte[%$ampl]
    add     al,64
    fld     dword[wavyAngLUT +eax*4]
;    fsub    dword[Real1d2]
    fmul    dword[%$damp]
    fadd    dword[edi +vertex.y]
    fmul    dword[RAS_main +raster.xtinfo +xtexinfo.uvMax +4]
    fxch    st1
;    fst     dword[edi +vertex.u1]
    fstp    dword[edi +vertex.u0]
;    fst     dword[edi +vertex.v1]
    fstp    dword[edi +vertex.v0]
.exit:
    MPOP    edi
DECLEND
;==============================================================================
SDECL _reversePicture, 0
;==============================================================================
    LCTX    esp
    LARG    4, _ratio, _total, _fade
    LVAR    4, blendf
    
    mov     dword[%$blendf],258
    fld     dword[%$_fade]
    fimul   dword[%$blendf]
    fistp   dword[%$blendf]
    mov     eax,256
    mov     edx,dword[%$blendf]
    sub     eax,edx
    js      .doxor
    CCALL   _TEX_blend, myscene +scene.fb,myscene +scene.fb,myscene +scene.fb,eax,edx,0x00ffffff
    jmp     .exit
.doxor:
    CCALL   _TEX_xor, myscene +scene.fb, 0x00ffffff
.exit:
DECLEND
;==============================================================================
SDECL _renderWavy, 0
;==============================================================================
    LCTX    esp
    LVAR    4, result
    CCALL   _clearBg, BGID_WAVY
    TexClear    myscene +scene.zb
    RasSetCam   wavyCamera
    
    CCALL   _renderWavyCyl
    
    CCALL   _getBeatDir
    fmul    dword[wavyBeatDamp]
    fmul    dword[beatTimer +timer.dt]
    fstp    dword[%$result]
    mov     eax,dword[%$result]
    CCALL   _PS_renderPhoton, wavyPhoton, eax

    CCALL   _TIMER_event, wavyRevEvent
.exit:
DECLEND
;==============================================================================
SDECL _renderWavyCyl, 0
;==============================================================================
    RasSetTex   0, gtexWavy
    RasSetCulling CULLING_FRONT
    RasSetFpgm _FPGM_T0bi_Z
    RasSetVpgm _VPGM_T0

    M33fromEuler OBJ_tform +objtform.rm, REAL_PID2,0,0
    V3setNull OBJ_tform +objtform.rm +matrix.t
    ObjSetScale wavyScale
    ObjSetVpgm _VPGM_wavyCyl
    ObjSetFlags 0, 0, 0
    RasSetVtxBuf [myobject], 256
    CCALL   _CYL_render3D, REAL_1D10000,[Real1], 32,48
.exit:
DECLEND
;==============================================================================
