struct VS_OUTPUT
{
  float4 Position: POSITION;
  float3 Tex0:     TEXCOORD0;
};

sampler Sampler = sampler_state
{
  MipFilter = LINEAR;
  MinFilter = LINEAR;
  MagFilter = LINEAR;
};

float V_Alpha : ALPHA;
float V_Var1 : VAR1;

float4 PS(VS_OUTPUT In) : COLOR0
{
  float4 color = tex2D(Sampler, In.Tex0.xy);
  float c = (color.r + color.g + color.b) / 3;
  color.r = ((c * 235/255) - color.r) * V_Var1 + color.r;
  color.g = ((c * 210/255) - color.g) * V_Var1 + color.g;
  color.b = ((c * 130/255) - color.b) * V_Var1 + color.b;
  color.a = V_Alpha * color.a;
  return color;
}

technique Colorize
{
  pass PassColorize
  {
    PixelShader = compile ps_2_0 PS();
  }
}
