float4x4 Matrix;
texture TextureMap;

sampler Sampler = sampler_state
{
    Texture   = (TextureMap);
    MipFilter = POINT;
    MinFilter = POINT;
    MagFilter = POINT;
};


struct VS_OUTPUT
{
	float4 Pos : POSITION;
	float2 UV : TEXCOORD0;
};

VS_OUTPUT VS(float3 Pos : POSITION, float2 TexUV : TEXCOORD0)
{
	VS_OUTPUT Out=(VS_OUTPUT)0;
	
	Out.Pos=mul(float4(Pos, 1), Matrix);
	Out.UV=TexUV;

	return Out;
}

float4 PS(float2 TexUV : TEXCOORD0) : COLOR
{
	return tex2D(Sampler, TexUV);
}

technique T0
{
	pass P0
	{
		VertexShader = compile vs_1_1 VS();
		PixelShader = compile ps_1_1 PS();
	}
}