texture EnvMap;
float4 Colour;
float4x4 Matrix;
float4x3 WorldMatrix;

float3 MinorMul;

//float MinorScale=0.035f;
float MinorScale=0.055f;
float Epsillon=0.00001f;

sampler Sampler = sampler_state
{
    Texture   = (EnvMap);
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
};

struct VS_OUTPUT
{
	float4 Pos : POSITION;
	float2 UV : TEXCOORD0;
};

VS_OUTPUT VS(float3 Pos : POSITION)
{
	VS_OUTPUT Out=(VS_OUTPUT)0;
	
	float Radius;
	float sina0, cosa0, sina1, cosa1;
	float3 Vert, Up, Left, VertScaled, Normal;
	
	//vert
	sincos(Pos.x, sina0, cosa0);
	sincos(Pos.y, sina1, cosa1);
	
	Vert.x=sina0*cosa1;
	Vert.y=sina0*sina1;
	Vert.z=cosa0;

	VertScaled=Vert*MinorMul;
	Radius = ( cos(VertScaled.x) + cos(VertScaled.y) + cos(VertScaled.z) );
	Vert*=(1.f+Radius*MinorScale);
	
	//up
	sincos(Pos.x, sina0, cosa0);
	sincos(Pos.y+Epsillon, sina1, cosa1);
	
	Up.x=sina0*cosa1;
	Up.y=sina0*sina1;
	Up.z=cosa0;

	VertScaled=Up*MinorMul;
	Radius = ( cos(VertScaled.x) + cos(VertScaled.y) + cos(VertScaled.z) );
	Up*=(1.f+Radius*MinorScale);

	//left
	sincos(Pos.x+Epsillon, sina0, cosa0);
	sincos(Pos.y, sina1, cosa1);
	
	Left.x=sina0*cosa1;
	Left.y=sina0*sina1;
	Left.z=cosa0;

	VertScaled=Left*MinorMul;
	Radius = ( cos(VertScaled.x) + cos(VertScaled.y) + cos(VertScaled.z) );
	Left*=(1.f+Radius*MinorScale);
	
	Up-=Vert;
	Left-=Vert;
	Normal=cross(Up, Left);
	Normal=normalize(Normal);

	Out.Pos=mul(float4(Vert, 1), Matrix);
//	Out.Col=float4(Normal, 1);
//	float4 bla=mul(float4(Normal, 1), float4x3(Matrix));
	float3 bla=normalize(mul(Normal, (float3x3)WorldMatrix));	
//	Out.Col=float4(bla, 1);
	Out.UV.x=bla.x*0.5f+0.5f;
	Out.UV.y=bla.y*0.5f+0.5f;
//	Out.Col=float4(1, 1, 1, 1);
	
	return Out;
}

float4 PS( float2 UV : TEXCOORD0 ) : COLOR
{
	return tex2D(Sampler, UV);
}

technique SphereDistort
{
	pass P0
	{
		VertexShader = compile vs_2_0 VS();
		PixelShader = compile ps_2_0 PS();
	}
}